/*
 * Decompiled with CFR 0.152.
 */
package deepnetts.net.train.opt;

import deepnetts.net.layers.AbstractLayer;
import deepnetts.net.train.opt.Optimizer;
import java.io.Serializable;

public final class SgdOptimizer
implements Optimizer,
Serializable {
    private float learningRate;

    public SgdOptimizer(AbstractLayer layer) {
        this.learningRate = layer.getLearningRate();
    }

    @Override
    public float calculateDeltaWeight(float gradient, int ... index) {
        return -this.learningRate * gradient;
    }

    @Override
    public float calculateDeltaBias(float gradient, int idx) {
        return -this.learningRate * gradient;
    }
}

