/*
 * Decompiled with CFR 0.152.
 */
package deepnetts.eval;

import deepnetts.eval.ConfusionMatrix;
import java.util.ArrayList;

public final class ClassificationMetrics {
    float truePositive;
    float trueNegative;
    float falsePositive;
    float falseNegative;
    float total;
    String classLabel;

    public ClassificationMetrics(int trueNegative, int falsePositive, int falseNegative, int truePositive) {
        this.truePositive = truePositive;
        this.trueNegative = trueNegative;
        this.falsePositive = falsePositive;
        this.falseNegative = falseNegative;
        this.total = falseNegative + falsePositive + trueNegative + truePositive;
    }

    public ClassificationMetrics(ConfusionMatrix cm) {
        this.truePositive = cm.getTruePositive();
        this.trueNegative = cm.getTrueNegative();
        this.falsePositive = cm.getFalsePositive();
        this.falseNegative = cm.getFalseNegative();
        this.total = this.falseNegative + this.falsePositive + this.trueNegative + this.truePositive;
    }

    public String getClassLabel() {
        return this.classLabel;
    }

    public void setClassLabel(String classLabel) {
        this.classLabel = classLabel;
    }

    public float getAccuracy() {
        return (this.truePositive + this.trueNegative) / this.total;
    }

    public float getErrorRate() {
        return (this.falsePositive + this.falseNegative) / this.total;
    }

    public float getPrecision() {
        return this.truePositive / (this.truePositive + this.falsePositive);
    }

    public float getRecall() {
        return this.truePositive / (this.truePositive + this.falsePositive);
    }

    public float getSpecificity() {
        return this.trueNegative / (this.trueNegative + this.falseNegative);
    }

    public float getF1Score() {
        float f1 = 2.0f * (this.getPrecision() * this.getRecall() / (this.getPrecision() + this.getRecall()));
        return f1;
    }

    public int getTotal() {
        return (int)this.total;
    }

    public float getFalsePositiveRate() {
        return this.falsePositive / (this.falsePositive + this.trueNegative);
    }

    public float getFalseNegativeRate() {
        return this.falseNegative / (this.falseNegative + this.truePositive);
    }

    public float getFalseDiscoveryRate() {
        return this.falsePositive / (this.falsePositive + this.truePositive);
    }

    public float positiveFreqency() {
        return (this.truePositive + this.falseNegative) / this.total;
    }

    public float negativeFreqency() {
        return (this.trueNegative + this.falsePositive) / this.total;
    }

    public float getFScore(int beta) {
        float f = (float)(beta * beta + 1) * this.getPrecision() * this.getRecall() / ((float)(beta * beta) * this.getPrecision() + this.getRecall());
        if (Double.isNaN(f)) {
            return 0.0f;
        }
        return f;
    }

    public double getMatthewsCorrelationCoefficient() {
        return (double)(this.truePositive * this.trueNegative - this.falsePositive * this.falseNegative) / Math.sqrt((this.truePositive + this.falsePositive) * (this.truePositive + this.falseNegative) * (this.trueNegative + this.falsePositive) * (this.trueNegative + this.falseNegative));
    }

    public double getBalancedClassificationRate() {
        if (this.trueNegative == 0.0f && this.falsePositive == 0.0f) {
            return this.truePositive / (this.truePositive + this.falseNegative);
        }
        if (this.truePositive == 0.0f && this.falseNegative == 0.0f) {
            return this.trueNegative / (this.trueNegative + this.falsePositive);
        }
        return 0.5 * (double)(this.truePositive / (this.truePositive + this.falseNegative) + this.trueNegative / (this.trueNegative + this.falsePositive));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Class: " + this.classLabel).append("\n");
        sb.append("Total items: ").append(this.getTotal()).append("\n");
        sb.append("True positive:").append(this.truePositive).append("\n");
        sb.append("True negative:").append(this.trueNegative).append("\n");
        sb.append("False positive:").append(this.falsePositive).append("\n");
        sb.append("False negative:").append(this.falseNegative).append("\n");
        sb.append("Accuracy (ACC): ").append(this.getAccuracy()).append("\n");
        sb.append("Sensitivity (TPR): ").append(this.getRecall()).append("\n");
        sb.append("Specificity (TNR): ").append(this.getSpecificity()).append("\n");
        sb.append("Fall-out (FPR): ").append(this.getFalsePositiveRate()).append("\n");
        sb.append("False negative rate (FNR): ").append(this.getFalseNegativeRate()).append("\n");
        sb.append("Precision (PPV): ").append(this.getPrecision()).append("\n");
        sb.append("Recall: ").append(this.getRecall()).append("\n");
        sb.append("F1 Score: ").append(this.getF1Score()).append("\n");
        sb.append("False discovery rate (FDR): ").append(this.getFalseDiscoveryRate()).append("\n");
        sb.append("Matthews correlation Coefficient (MCC): ").append(this.getMatthewsCorrelationCoefficient()).append("\n");
        return sb.toString();
    }

    public static ClassificationMetrics[] createFrom(ConfusionMatrix confusionMatrix) {
        int classCount = confusionMatrix.getClassCount();
        if (classCount == 2) {
            ClassificationMetrics[] measures = new ClassificationMetrics[1];
            String[] classLabels = confusionMatrix.getClassLabels();
            int tp = confusionMatrix.getTruePositive();
            int tn = confusionMatrix.getTrueNegative();
            int fp = confusionMatrix.getFalsePositive();
            int fn = confusionMatrix.getFalseNegative();
            measures[0] = new ClassificationMetrics(tn, fp, fn, tp);
            measures[0].setClassLabel(classLabels[0]);
            return measures;
        }
        ClassificationMetrics[] measures = new ClassificationMetrics[classCount];
        String[] classLabels = confusionMatrix.getClassLabels();
        for (int clsIdx = 0; clsIdx < confusionMatrix.getClassCount(); ++clsIdx) {
            int tp = confusionMatrix.getTruePositive(clsIdx);
            int tn = confusionMatrix.getTrueNegative(clsIdx);
            int fp = confusionMatrix.getFalsePositive(clsIdx);
            int fn = confusionMatrix.getFalseNegative(clsIdx);
            measures[clsIdx] = new ClassificationMetrics(tn, fp, fn, tp);
            measures[clsIdx].setClassLabel(classLabels[clsIdx]);
        }
        return measures;
    }

    public static Stats average(ClassificationMetrics[] results) {
        ArrayList<String> classLabels = new ArrayList<String>();
        Stats average = new Stats();
        double count = 0.0;
        for (ClassificationMetrics cm : results) {
            average.accuracy += (double)cm.getAccuracy();
            average.precision += (double)cm.getPrecision();
            average.recall += (double)cm.getRecall();
            average.fScore += (double)cm.getF1Score();
            if (classLabels.contains(cm.getClassLabel())) continue;
            classLabels.add(cm.getClassLabel());
        }
        count += 1.0;
        average.accuracy /= (count *= (double)classLabels.size());
        average.precision /= count;
        average.recall /= count;
        average.fScore /= count;
        average.mserror /= count;
        return average;
    }

    public static class Stats {
        public double accuracy = 0.0;
        public double precision = 0.0;
        public double recall = 0.0;
        public double fScore = 0.0;
        public double mserror = 0.0;
        public double correlationCoefficient = 0.0;

        public String toString() {
            return "Stats{accuracy=" + this.accuracy + ", precision=" + this.precision + ", recall=" + this.recall + ", fScore=" + this.fScore + ", mserror=" + this.mserror + ", corelationCoefficient=" + this.correlationCoefficient + '}';
        }
    }
}

