/*
 * Decompiled with CFR 0.152.
 */
package deepnetts.eval;

public class ConfusionMatrix {
    private final String[] classLabels;
    private final int[][] values;
    private final int classCount;
    private int totalItems = 0;
    private static final int STRING_DEFAULT_WIDTH = 7;
    public static final String TRUE_POSITIVE = "TruePositive";
    public static final String TRUE_NEGATIVE = "TrueNegative";
    public static final String FALSE_POSITIVE = "FalsePositive";
    public static final String FALSE_NEGATIVE = "FalseNegative";

    public ConfusionMatrix(String[] classLabels) {
        if (classLabels == null) {
            throw new IllegalArgumentException("Class labels cannot be null!");
        }
        for (String label : classLabels) {
            if (label != null && !label.isEmpty()) continue;
            throw new IllegalArgumentException("Class label cannot be null or empty String!");
        }
        this.classLabels = classLabels;
        this.classCount = classLabels.length;
        this.values = new int[this.classCount][this.classCount];
    }

    public final int get(int predictedIdx, int actualIdx) {
        return this.values[predictedIdx][actualIdx];
    }

    public final void inc(int actualIdx, int predictedIdx) {
        int[] nArray = this.values[actualIdx];
        int n = predictedIdx;
        nArray[n] = nArray[n] + 1;
        ++this.totalItems;
    }

    public final int getClassCount() {
        return this.classCount;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        int maxColumnLenght = 7;
        for (String label : this.classLabels) {
            maxColumnLenght = Math.max(maxColumnLenght, label.length());
        }
        builder.append(String.format("%1$" + maxColumnLenght + "s", ""));
        for (String label : this.classLabels) {
            builder.append(String.format("%1$" + maxColumnLenght + "s", label));
        }
        builder.append("\n");
        for (int i = 0; i < this.values.length; ++i) {
            builder.append(String.format("%1$" + maxColumnLenght + "s", this.classLabels[i]));
            for (int j = 0; j < this.values[0].length; ++j) {
                builder.append(String.format("%1$" + maxColumnLenght + "s", this.values[i][j]));
            }
            builder.append("\n");
        }
        return builder.toString();
    }

    public int getTruePositive() {
        return this.values[1][1];
    }

    public int getTruePositive(int clsIdx) {
        return this.values[clsIdx][clsIdx];
    }

    public int getTrueNegative() {
        return this.values[0][0];
    }

    public int getTrueNegative(int clsIdx) {
        int trueNegative = 0;
        trueNegative = this.values[0][0];
        return trueNegative;
    }

    public int getFalsePositive() {
        return this.values[0][1];
    }

    public int getFalsePositive(int clsIdx) {
        int falsePositive = 0;
        for (int i = 0; i < this.classCount; ++i) {
            if (i == clsIdx) continue;
            falsePositive += this.values[i][clsIdx];
        }
        return falsePositive;
    }

    public int getFalseNegative(int clsIdx) {
        int falseNegative = 0;
        for (int i = 0; i < this.classCount; ++i) {
            if (i == clsIdx) continue;
            falseNegative += this.values[clsIdx][i];
        }
        return falseNegative;
    }

    public int getFalseNegative() {
        return this.values[1][0];
    }

    public final String[] getClassLabels() {
        return this.classLabels;
    }

    public int getTotalItems() {
        return this.totalItems;
    }
}

