/*
 * Decompiled with CFR 0.152.
 */
package deepnetts.net;

import deepnetts.net.NeuralNetwork;
import deepnetts.net.layers.AbstractLayer;
import deepnetts.net.layers.ConvolutionalLayer;
import deepnetts.net.layers.FullyConnectedLayer;
import deepnetts.net.layers.InputLayer;
import deepnetts.net.layers.MaxPoolingLayer;
import deepnetts.net.layers.OutputLayer;
import deepnetts.net.layers.SoftmaxOutputLayer;
import deepnetts.net.layers.activation.ActivationType;
import deepnetts.net.loss.BinaryCrossEntropyLoss;
import deepnetts.net.loss.CrossEntropyLoss;
import deepnetts.net.loss.LossFunction;
import deepnetts.net.loss.LossType;
import deepnetts.net.loss.MeanSquaredErrorLoss;
import deepnetts.net.train.BackpropagationTrainer;
import deepnetts.util.DeepNettsException;
import deepnetts.util.RandomGenerator;
import deepnetts.util.Tensor;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConvolutionalNetwork
extends NeuralNetwork<BackpropagationTrainer>
implements Serializable {
    private ConvolutionalNetwork() {
        this.setTrainer(new BackpropagationTrainer(this));
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<String> getWeights() {
        ArrayList<String> weightsList = new ArrayList<String>();
        for (AbstractLayer layer : this.getLayers()) {
            if (layer instanceof ConvolutionalLayer) {
                Tensor[] filters = ((ConvolutionalLayer)layer).getFilters();
                String filterStr = Tensor.valuesAsString(filters);
                weightsList.add(filterStr);
                continue;
            }
            weightsList.add(layer.getDeltaWeights().toString());
        }
        return weightsList;
    }

    public void setWeights(List<String> weights) {
        int weightsIdx = 0;
        for (int layerIdx = 1; layerIdx < this.getLayers().size(); ++layerIdx) {
            AbstractLayer layer = this.getLayers().get(layerIdx);
            if (layer instanceof ConvolutionalLayer) {
                ((ConvolutionalLayer)layer).setFilters(weights.get(weightsIdx));
                ++weightsIdx;
                continue;
            }
            if (!(layer instanceof FullyConnectedLayer) && !(layer instanceof OutputLayer)) continue;
            layer.setWeights(weights.get(weightsIdx));
            ++weightsIdx;
        }
    }

    public List<String> getDeltaWeights() {
        ArrayList<String> weightsList = new ArrayList<String>();
        for (AbstractLayer layer : this.getLayers()) {
            weightsList.add(layer.getDeltaWeights().toString());
        }
        return weightsList;
    }

    public List<String> getAllOutputs() {
        ArrayList<String> outputsList = new ArrayList<String>();
        for (AbstractLayer layer : this.getLayers()) {
            outputsList.add((String)((Object)layer.getOutputs()));
        }
        return outputsList;
    }

    public static class Builder {
        private final ConvolutionalNetwork neuralNet = new ConvolutionalNetwork();
        private ActivationType defaultActivationType = ActivationType.RELU;
        private Class<CrossEntropyLoss> defaultLossFunction = CrossEntropyLoss.class;
        private boolean setDefaultActivation = false;

        public Builder addInputLayer(int width, int height) {
            InputLayer inLayer = new InputLayer(width, height, 3);
            this.neuralNet.setInputLayer(inLayer);
            this.neuralNet.addLayer(inLayer);
            return this;
        }

        public Builder addInputLayer(int width, int height, int channels) {
            InputLayer inLayer = new InputLayer(width, height, channels);
            this.neuralNet.setInputLayer(inLayer);
            this.neuralNet.addLayer(inLayer);
            return this;
        }

        public Builder addFullyConnectedLayer(int width) {
            FullyConnectedLayer layer = new FullyConnectedLayer(width);
            this.neuralNet.addLayer(layer);
            return this;
        }

        public Builder addFullyConnectedLayer(int width, ActivationType activationType) {
            FullyConnectedLayer layer = new FullyConnectedLayer(width, activationType);
            this.neuralNet.addLayer(layer);
            return this;
        }

        public Builder addOutputLayer(int width, Class<? extends OutputLayer> clazz) {
            try {
                OutputLayer outputLayer = clazz.getDeclaredConstructor(Integer.TYPE).newInstance(width);
                this.neuralNet.addLayer(outputLayer);
                this.neuralNet.setOutputLayer(outputLayer);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                Logger.getLogger(ConvolutionalNetwork.class.getName()).log(Level.SEVERE, null, ex);
            }
            return this;
        }

        public Builder addOutputLayer(int width, ActivationType activationType) {
            OutputLayer outputLayer = null;
            if (activationType.equals((Object)ActivationType.SOFTMAX)) {
                outputLayer = new SoftmaxOutputLayer(width);
            } else {
                outputLayer = new OutputLayer(width);
                outputLayer.setActivationType(activationType);
            }
            this.neuralNet.setOutputLayer(outputLayer);
            this.neuralNet.addLayer(outputLayer);
            return this;
        }

        public Builder addConvolutionalLayer(int filterSize, int channels) {
            ConvolutionalLayer convolutionalLayer = new ConvolutionalLayer(filterSize, filterSize, channels, this.defaultActivationType);
            this.neuralNet.addLayer(convolutionalLayer);
            return this;
        }

        public Builder addConvolutionalLayer(int filterSize, int channels, ActivationType activationType) {
            ConvolutionalLayer convolutionalLayer = new ConvolutionalLayer(filterSize, filterSize, channels, activationType);
            this.neuralNet.addLayer(convolutionalLayer);
            return this;
        }

        public Builder addConvolutionalLayer(int filterWidth, int filterHeight, int channels) {
            ConvolutionalLayer convolutionalLayer = new ConvolutionalLayer(filterWidth, filterHeight, channels, this.defaultActivationType);
            this.neuralNet.addLayer(convolutionalLayer);
            return this;
        }

        public Builder addConvolutionalLayer(int filterWidth, int filterHeight, int channels, int stride) {
            ConvolutionalLayer convolutionalLayer = new ConvolutionalLayer(filterWidth, filterHeight, stride, channels, this.defaultActivationType);
            this.neuralNet.addLayer(convolutionalLayer);
            return this;
        }

        public Builder addConvolutionalLayer(int filterWidth, int filterHeight, int channels, ActivationType activationType) {
            ConvolutionalLayer convolutionalLayer = new ConvolutionalLayer(filterWidth, filterHeight, channels, activationType);
            this.neuralNet.addLayer(convolutionalLayer);
            return this;
        }

        public Builder addConvolutionalLayer(int filterWidth, int filterHeight, int channels, int stride, ActivationType activationType) {
            ConvolutionalLayer convolutionalLayer = new ConvolutionalLayer(filterWidth, filterHeight, channels, stride, activationType);
            this.neuralNet.addLayer(convolutionalLayer);
            return this;
        }

        public Builder addMaxPoolingLayer(int filterSize, int stride) {
            MaxPoolingLayer poolingLayer = new MaxPoolingLayer(filterSize, filterSize, stride);
            this.neuralNet.addLayer(poolingLayer);
            return this;
        }

        public Builder addMaxPoolingLayer(int filterWidth, int filterHeight, int stride) {
            MaxPoolingLayer poolingLayer = new MaxPoolingLayer(filterWidth, filterHeight, stride);
            this.neuralNet.addLayer(poolingLayer);
            return this;
        }

        public Builder hiddenActivationFunction(ActivationType activationType) {
            this.defaultActivationType = activationType;
            this.setDefaultActivation = true;
            return this;
        }

        public Builder lossFunction(Class<? extends LossFunction> clazz) {
            try {
                LossFunction loss = clazz.getDeclaredConstructor(NeuralNetwork.class).newInstance(this.neuralNet);
                this.neuralNet.setLossFunction(loss);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                Logger.getLogger(ConvolutionalNetwork.class.getName()).log(Level.SEVERE, null, ex);
            }
            return this;
        }

        public Builder lossFunction(LossType lossType) {
            LossFunction loss = null;
            switch (lossType) {
                case MEAN_SQUARED_ERROR: {
                    loss = new MeanSquaredErrorLoss(this.neuralNet);
                    break;
                }
                case CROSS_ENTROPY: {
                    if (this.neuralNet.getOutputLayer().getWidth() == 1) {
                        if (this.neuralNet.getOutputLayer().getActivationType() != ActivationType.SIGMOID) {
                            throw new DeepNettsException("Illegal combination of activation and loss functions (Sigmoid activation must be used with Cross Entropy Loss)");
                        }
                        loss = new BinaryCrossEntropyLoss(this.neuralNet);
                        break;
                    }
                    if (this.neuralNet.getOutputLayer().getActivationType() == ActivationType.SOFTMAX) break;
                    loss = new CrossEntropyLoss(this.neuralNet);
                }
            }
            this.neuralNet.setLossFunction(loss);
            return this;
        }

        public Builder randomSeed(long seed) {
            RandomGenerator.getDefault().initSeed(seed);
            return this;
        }

        public ConvolutionalNetwork build() {
            AbstractLayer prevLayer = null;
            for (int i = 0; i < this.neuralNet.getLayers().size(); ++i) {
                AbstractLayer layer2 = this.neuralNet.getLayers().get(i);
                if (this.setDefaultActivation && !(layer2 instanceof InputLayer) && !(layer2 instanceof OutputLayer)) {
                    layer2.setActivationType(this.defaultActivationType);
                }
                layer2.setPrevLayer(prevLayer);
                if (prevLayer != null) {
                    prevLayer.setNextlayer(layer2);
                }
                prevLayer = layer2;
            }
            this.neuralNet.getLayers().forEach(layer -> layer.init());
            if (this.neuralNet.getLossFunction() == null) {
                this.lossFunction(this.defaultLossFunction);
            }
            return this.neuralNet;
        }
    }
}

