/*
 * Decompiled with CFR 0.152.
 */
package deepnetts.net;

import deepnetts.net.ConvolutionalNetwork;
import deepnetts.net.FeedForwardNetwork;

public enum NetworkType {
    FEEDFORWARD("FEEDFORWARD"),
    CONVOLUTIONAL("CONVOLUTIONAL");

    private final String name;

    private NetworkType(String s) {
        this.name = s;
    }

    public boolean equalsName(String otherName) {
        return this.name.equals(otherName);
    }

    public static NetworkType Of(Class networkClass) {
        if (networkClass.equals(FeedForwardNetwork.class)) {
            return FEEDFORWARD;
        }
        if (networkClass.equals(ConvolutionalNetwork.class)) {
            return CONVOLUTIONAL;
        }
        throw new RuntimeException("Unknown network type!");
    }

    public String toString() {
        return this.name;
    }
}

