/*
 * Decompiled with CFR 0.152.
 */
package deepnetts.net.layers;

import deepnetts.net.layers.Layer;
import deepnetts.net.layers.activation.ActivationFunction;
import deepnetts.net.layers.activation.ActivationType;
import deepnetts.net.train.opt.Optimizer;
import deepnetts.net.train.opt.OptimizerType;
import deepnetts.net.weights.RandomWeightsType;
import deepnetts.util.Tensor;
import java.io.Serializable;

public abstract class AbstractLayer
implements Layer,
Serializable {
    private static final long serialVersionUid = 1L;
    protected AbstractLayer prevLayer;
    protected AbstractLayer nextLayer;
    protected Tensor weights;
    protected Tensor inputs;
    protected Tensor outputs;
    protected Tensor deltas;
    protected Tensor prevGradSqrSum;
    protected Tensor prevBiasSqrSum;
    protected Tensor prevDeltaWeightSqrSum;
    protected Tensor prevDeltaBiasSqrSum;
    protected Tensor deltaWeights;
    protected Tensor prevDeltaWeights;
    protected Tensor gradients;
    protected ActivationFunction activation;
    protected float learningRate = 0.1f;
    protected float momentum = 0.0f;
    protected float regularization = 0.0f;
    protected ActivationType activationType;
    protected OptimizerType optimizerType = OptimizerType.SGD;
    protected boolean batchMode = false;
    protected int batchSize = 0;
    protected int width;
    protected int height;
    protected int depth;
    protected float[] biases;
    protected float[] deltaBiases;
    protected float[] prevDeltaBiases;
    protected Optimizer optim;
    protected RandomWeightsType randomWeightsType = RandomWeightsType.XAVIER;

    public abstract void init();

    @Override
    public abstract void forward();

    @Override
    public abstract void backward();

    public abstract void applyWeightChanges();

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getDepth() {
        return this.depth;
    }

    public AbstractLayer getPrevlayer() {
        return this.prevLayer;
    }

    public void setPrevLayer(AbstractLayer prevLayer) {
        this.prevLayer = prevLayer;
    }

    public void setNextlayer(AbstractLayer nextlayer) {
        this.nextLayer = nextlayer;
    }

    public AbstractLayer getNextLayer() {
        return this.nextLayer;
    }

    public Tensor getWeights() {
        return this.weights;
    }

    public float[] getBiases() {
        return this.biases;
    }

    public void setBiases(float[] biases) {
        this.biases = biases;
    }

    @Override
    public final Tensor getOutputs() {
        return this.outputs;
    }

    @Override
    public final Tensor getDeltas() {
        return this.deltas;
    }

    public final Tensor getGradients() {
        return this.gradients;
    }

    public Tensor getDeltaWeights() {
        return this.deltaWeights;
    }

    public Tensor getPrevDeltaWeights() {
        return this.prevDeltaWeights;
    }

    public void setPrevDeltaWeights(Tensor prevDeltaWeights) {
        this.prevDeltaWeights = prevDeltaWeights;
    }

    public float[] getPrevDeltaBiases() {
        return this.prevDeltaBiases;
    }

    public float[] getDeltaBiases() {
        return this.deltaBiases;
    }

    public final void setOutputs(Tensor outputs) {
        this.outputs = outputs;
    }

    public void setWeights(Tensor weights) {
        this.weights = weights;
    }

    public void setWeights(String weightStr) {
        this.weights.setValuesFromString(weightStr);
    }

    public final void setDeltas(Tensor deltas) {
        this.deltas = deltas;
    }

    public ActivationFunction getActivation() {
        return this.activation;
    }

    public void setActivation(ActivationFunction activation) {
        this.activation = activation;
    }

    public float getLearningRate() {
        return this.learningRate;
    }

    public void setLearningRate(float learningRate) {
        this.learningRate = learningRate;
    }

    public boolean isBatchMode() {
        return this.batchMode;
    }

    public void setBatchMode(boolean batchMode) {
        this.batchMode = batchMode;
    }

    public float getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setMomentum(float momentum) {
        this.momentum = momentum;
    }

    public float getMomentum() {
        return this.momentum;
    }

    public OptimizerType getOptimizerType() {
        return this.optimizerType;
    }

    public void setOptimizerType(OptimizerType optType) {
        this.optimizerType = optType;
        this.optim = Optimizer.create(optType, this);
    }

    public ActivationType getActivationType() {
        return this.activationType;
    }

    public final void setActivationType(ActivationType activationType) {
        this.activationType = activationType;
        if (activationType != ActivationType.SOFTMAX) {
            this.activation = ActivationFunction.create(activationType);
        }
    }

    public float getL1() {
        return this.weights.sumAbs();
    }

    public float getL2() {
        return this.weights.sumSqr();
    }

    public void setRegularization(float reg) {
        this.regularization = reg;
    }
}

