/*
 * Decompiled with CFR 0.152.
 */
package deepnetts.net.layers;

import deepnetts.net.layers.AbstractLayer;
import deepnetts.util.Tensor;

public class InputLayer
extends AbstractLayer {
    public InputLayer(int width, int height, int depth) {
        this.width = width;
        this.height = height;
        this.depth = depth;
        this.init();
    }

    public InputLayer(int width, int height) {
        this.width = width;
        this.height = height;
        this.depth = 1;
        this.init();
    }

    public InputLayer(int width) {
        this.width = width;
        this.height = 1;
        this.depth = 1;
        this.init();
    }

    @Override
    public final void init() {
        this.outputs = this.inputs = new Tensor(this.height, this.width, this.depth);
    }

    public void setInput(Tensor in) {
        this.inputs.setValues(in.getValues());
    }

    @Override
    public void forward() {
        throw new IllegalStateException("This method does nothing and should never be called");
    }

    @Override
    public void backward() {
        throw new IllegalStateException("This method does nothing and should never be called");
    }

    @Override
    public void applyWeightChanges() {
    }

    public String toString() {
        if (this.height == 1 && this.depth == 1) {
            return "Input Layer { width:" + this.width + ", height:" + this.height + ", depth:" + this.depth + " }";
        }
        return "Input Layer { width:" + this.width + ", height:" + this.height + ", depth:" + this.depth + " }";
    }
}

