/*
 * Decompiled with CFR 0.152.
 */
package deepnetts.net.loss;

import deepnetts.net.loss.BinaryCrossEntropyLoss;
import deepnetts.net.loss.CrossEntropyLoss;
import deepnetts.net.loss.MeanSquaredErrorLoss;

public enum LossType {
    MEAN_SQUARED_ERROR("MEAN_SQUARED_ERROR"),
    CROSS_ENTROPY("CROSS_ENTROPY");

    private final String name;

    private LossType(String name) {
        this.name = name;
    }

    public boolean equalsName(String otherName) {
        return this.name.equals(otherName);
    }

    public static LossType of(Class lossClass) {
        if (lossClass.equals(MeanSquaredErrorLoss.class)) {
            return MEAN_SQUARED_ERROR;
        }
        if (lossClass.equals(CrossEntropyLoss.class) || lossClass.equals(BinaryCrossEntropyLoss.class)) {
            return CROSS_ENTROPY;
        }
        throw new RuntimeException("Unknown loss type!");
    }

    public String toString() {
        return this.name;
    }
}

