/*
 * Decompiled with CFR 0.152.
 */
package deepnetts.net.weights;

import deepnetts.util.RandomGenerator;

public class RandomWeights {
    private static RandomGenerator randomGen = RandomGenerator.getDefault();

    public static void initSeed(long seed) {
        RandomGenerator.getDefault().initSeed(seed);
    }

    public static void randomize(float[] array) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = randomGen.nextFloat() - 0.5f;
        }
    }

    public static void widrowHoff(float[] array, float input, float hidden) {
        int i;
        RandomWeights.randomize(array);
        float beta = 0.7f * (float)Math.pow(hidden, 1.0f / input);
        float weightsNorm = 0.0f;
        for (i = 0; i < array.length; ++i) {
            weightsNorm += array[i] * array[i];
        }
        weightsNorm = (float)Math.sqrt(weightsNorm);
        for (i = 0; i < array.length; ++i) {
            array[i] = beta * array[i] / weightsNorm;
        }
    }

    public static void uniform(float[] weights, int numInputs) {
        if (numInputs == 0) {
            throw new IllegalArgumentException("Number of inputs for uniform randomization cannot be zero!");
        }
        float min = -1.0f / (float)Math.sqrt(numInputs);
        float max = 1.0f / (float)Math.sqrt(numInputs);
        for (int i = 0; i < weights.length; ++i) {
            weights[i] = min + randomGen.nextFloat() * (max - min);
        }
    }

    public static void uniform(float[] weights, float min, float max) {
        for (int i = 0; i < weights.length; ++i) {
            weights[i] = min + randomGen.nextFloat() * (max - min);
        }
    }

    public static void he(float[] weights, int numInputs) {
        RandomWeights.gaussian(weights, 0.0f, (float)Math.sqrt(2.0f / (float)numInputs));
    }

    public static void gaussian(float[] weights, float mean, float std) {
        for (int i = 0; i < weights.length; ++i) {
            weights[i] = randomGen.nextGaussian() * std + mean;
        }
    }

    public static void normal(float[] weights) {
        RandomWeights.gaussian(weights, 0.0f, 1.0f);
    }

    public static void xavier(float[] weights, int numIn, int numOut) {
        float min = (float)(-Math.sqrt(6.0f / (float)(numIn + numOut)));
        float max = (float)Math.sqrt(6.0f / (float)(numIn + numOut));
        for (int i = 0; i < weights.length; ++i) {
            weights[i] = min + randomGen.nextFloat() * (max - min);
        }
    }
}

