/*
 * Decompiled with CFR 0.152.
 */
package deepnetts.util;

import deepnetts.data.ExampleImage;
import deepnetts.data.ImageSet;
import deepnetts.util.DeepNettsException;
import deepnetts.util.ImageUtils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public class ImageSetUtils {
    public static final String LABELS_FILE = "labels.txt";
    public static final String TRAIN_FILE = "train.txt";
    public static final String TEST_FILE = "test.txt";
    public static final String IMAGE_IDX_FILE = "index.txt";
    private static final Logger LOGGER = Logger.getLogger(ImageSetUtils.class.getName());

    public static ImageSet createDataSetFromRawImages(String sourcePath, String targetPath, int targetWidth, int targetHeight, boolean useAbsolutePaths) throws IOException {
        ImageSet imageSet = new ImageSet(targetWidth, targetHeight);
        List<String> labels = ImageSetUtils.labelsFromSubDirectories(sourcePath);
        ArrayList<String> imgIndex = new ArrayList<String>();
        for (String label : labels) {
            ImageSetUtils.createdDirectory(new File(targetPath + File.separator + label));
            HashMap<File, BufferedImage> categoryImages = ImageUtils.loadFileImageMapFromDirectory(new File(sourcePath + File.separator + label));
            int count = 0;
            for (Map.Entry entry : categoryImages.entrySet()) {
                String fileName = ((File)entry.getKey()).getName();
                LOGGER.info("Processing image " + fileName);
                BufferedImage scaledImage = ImageUtils.scaleBySmallerAndCrop((BufferedImage)entry.getValue(), targetWidth, targetHeight);
                imageSet.add(new ExampleImage(scaledImage, label));
                String imgType = ImageUtils.getImageType((File)entry.getKey());
                String targetFile = targetPath + File.separator + label + File.separator + label + "_" + ++count + "." + imgType;
                ImageIO.write((RenderedImage)scaledImage, imgType, new File(targetFile));
                if (useAbsolutePaths) {
                    imgIndex.add(targetFile + " " + label);
                } else {
                    imgIndex.add(label + File.separator + fileName + " " + label);
                }
                LOGGER.info(targetFile + " done!");
            }
        }
        ImageSetUtils.writeToFile(labels, targetPath + File.separator + LABELS_FILE);
        ImageSetUtils.writeToFile(imgIndex, targetPath + File.separator + IMAGE_IDX_FILE);
        return imageSet;
    }

    public static void createRandomlyCroppedImages(String srcPath, String destPath, int targetWidth, int targetHeight, int num) throws IOException {
        List<String> labels = ImageSetUtils.labelsFromSubDirectories(srcPath);
        ArrayList imgIndex = new ArrayList();
        Random random = new Random(123L);
        for (String label : labels) {
            ImageSetUtils.createdDirectory(new File(destPath + File.separator + label));
            HashMap<File, BufferedImage> categoryImages = ImageUtils.loadFileImageMapFromDirectory(new File(srcPath + File.separator + label));
            int count = 0;
            for (Map.Entry entry : categoryImages.entrySet()) {
                String fileName = ((File)entry.getKey()).getName();
                LOGGER.info("Processing image " + fileName);
                List<BufferedImage> randomlyCropedImages = ImageUtils.randomCrop((BufferedImage)entry.getValue(), targetWidth, targetHeight, num, random);
                String imgType = ImageUtils.getImageType((File)entry.getKey());
                String targetFile = label + File.separator + label + "_" + ++count;
                ImageUtils.writeImages(randomlyCropedImages, destPath, targetFile, imgType);
                LOGGER.info(targetFile + " done!");
            }
        }
    }

    private static void createdDirectory(File dir) {
        if (!dir.exists()) {
            dir.mkdir();
        }
    }

    public static List<String> labelsFromSubDirectories(String path) {
        String[] subDirs;
        ArrayList<String> labels = new ArrayList<String>();
        File rootDir = new File(path);
        if (!rootDir.isDirectory()) {
            throw new DeepNettsException("Specified path must be a directory: " + path);
        }
        for (String dir : subDirs = rootDir.list()) {
            if (!new File(path + "/" + dir).isDirectory()) continue;
            labels.add(dir);
        }
        return labels;
    }

    public static void writeToFile(List<String> list, String fileName) throws IOException {
        File file = new File(fileName);
        try (PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(file)));){
            list.forEach(item -> pw.println((String)item));
        }
    }

    public static void createLabelsIndex(String path) throws IOException {
        List<String> labels = ImageSetUtils.labelsFromSubDirectories(path);
        labels.remove("negative");
        Collections.sort(labels);
        ImageSetUtils.writeToFile(labels, path + File.separator + LABELS_FILE);
    }

    public static File createImageIndex(String path) throws IOException {
        File rootDir = new File(path);
        if (!rootDir.isDirectory()) {
            throw new DeepNettsException("Specified path must be a directory: " + path);
        }
        File imageIdxFile = new File(path + "/" + IMAGE_IDX_FILE);
        try (PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(imageIdxFile)));){
            String[] subDirs = rootDir.list();
            LinkedList<String> lines = new LinkedList<String>();
            for (String classDirName : subDirs) {
                String[] imageFiles;
                File classDirFile = new File(path + File.separator + classDirName);
                if (!classDirFile.isDirectory()) continue;
                String label = classDirName;
                for (String imageFile : imageFiles = classDirFile.list()) {
                    lines.add(classDirName + File.separator + imageFile + " " + label);
                }
            }
            Collections.shuffle(lines);
            lines.stream().forEach(line -> pw.println((String)line));
        }
        return imageIdxFile;
    }

    public static void renameFilesAsClasses(String srcPath, String className) throws FileNotFoundException {
        File sourceDir = new File(srcPath);
        if (!sourceDir.exists()) {
            throw new FileNotFoundException("Source directory '" + srcPath + "' not found!");
        }
        if (!sourceDir.isDirectory()) {
            throw new DeepNettsException(srcPath + "is not a directory!");
        }
        File[] files = sourceDir.listFiles();
        int z = 1;
        while (Math.pow(10.0, z) < (double)files.length) {
            ++z;
        }
        for (int i = 0; i < files.length; ++i) {
            String leadingZeros = ImageSetUtils.getLeadingZeros(i, z);
            if (!files[i].renameTo(new File(srcPath + "/" + className + "_" + leadingZeros + i + ".jpg"))) continue;
            System.out.println("Renamed " + className + "_" + i);
        }
    }

    public static File createSubSampledImageIndex(String srcDir, String targetFileName, int samplesPerClass, boolean useFullPath) throws IOException {
        File imageIdxFile = new File(targetFileName);
        try (PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(imageIdxFile)));){
            String[] subDirs;
            File file = new File(srcDir);
            for (String classDirName : subDirs = file.list()) {
                File classDirFile = new File(srcDir + "/" + classDirName);
                if (!classDirFile.isDirectory()) continue;
                String label = classDirName;
                String[] imageFiles = classDirFile.list();
                for (int i = 0; i < samplesPerClass; ++i) {
                    String imageFile = imageFiles[i];
                    if (useFullPath) {
                        pw.println(srcDir + "/" + classDirName + "/" + imageFile + " " + label);
                        continue;
                    }
                    pw.println(classDirName + "/" + imageFile + " " + label);
                }
            }
        }
        return imageIdxFile;
    }

    private static String getLeadingZeros(int i, int z) {
        String leadingZeros = "";
        int digits = ("" + i).length();
        for (int a = 0; a < z - digits; ++a) {
            leadingZeros = leadingZeros + "0";
        }
        return leadingZeros;
    }

    public static void main(String[] args) {
    }
}

