/*
 * Decompiled with CFR 0.152.
 */
package deepnetts.util;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.imageio.ImageIO;

public class ImageUtils {
    private ImageUtils() {
    }

    public static BufferedImage scaleImage(BufferedImage img, int newWidth, int newHeight) {
        Image scaledImg = img.getScaledInstance(newWidth, newHeight, 2);
        BufferedImage resultImg = new BufferedImage(newWidth, newHeight, 2);
        resultImg.getGraphics().drawImage(scaledImg, 0, 0, null);
        return resultImg;
    }

    public static BufferedImage scaleAndCenter(BufferedImage img, int targetWidth, int targetHeight, int padding, Color bgColor) {
        int yPos;
        int xPos;
        int imgWidth = img.getWidth();
        int imgHeight = img.getHeight();
        float scaleFactor = 0.0f;
        scaleFactor = imgWidth > imgHeight ? (float)imgWidth / (float)(targetWidth - 2 * padding) : (float)imgHeight / (float)(targetHeight - 2 * padding);
        int newWidth = (int)((float)imgWidth / scaleFactor);
        int newHeight = (int)((float)imgHeight / scaleFactor);
        Image scaledImg = img.getScaledInstance(newWidth, newHeight, imgWidth);
        BufferedImage resultImg = new BufferedImage(targetWidth, targetHeight, img.getType());
        resultImg.getGraphics().setColor(bgColor);
        resultImg.getGraphics().fillRect(0, 0, targetWidth, targetHeight);
        if (imgWidth > imgHeight) {
            xPos = padding;
            yPos = padding + (targetHeight - 2 * padding - newHeight) / 2;
        } else {
            xPos = padding + (targetWidth - 2 * padding - newWidth) / 2;
            yPos = padding;
        }
        resultImg.getGraphics().drawImage(scaledImg, xPos, yPos, null);
        return resultImg;
    }

    public static BufferedImage scaleBySmallerAndCrop(BufferedImage img, int targetWidth, int targetHeight) {
        int imgWidth = img.getWidth();
        int imgHeight = img.getHeight();
        float scale = 0.0f;
        scale = imgWidth < imgHeight ? (float)imgWidth / (float)targetWidth : (float)imgHeight / (float)targetHeight;
        int newWidth = (int)((float)imgWidth / scale);
        int newHeight = (int)((float)imgHeight / scale);
        Image scaledImg = img.getScaledInstance(newWidth, newHeight, imgWidth);
        BufferedImage scaledBuffImg = new BufferedImage(newWidth, newHeight, img.getType());
        scaledBuffImg.getGraphics().drawImage(scaledImg, 0, 0, null);
        BufferedImage resultImage = null;
        if (imgWidth < imgHeight) {
            boolean xPos = false;
            int yPos = (newHeight - targetHeight) / 2;
            resultImage = scaledBuffImg.getSubimage(0, yPos, targetWidth, targetHeight);
        } else {
            int xPos = (newWidth - targetWidth) / 2;
            boolean yPos = false;
            resultImage = scaledBuffImg.getSubimage(xPos, 0, targetWidth, targetHeight);
        }
        return resultImage;
    }

    public static List<BufferedImage> loadImagesFromDirectory(File dir) throws IOException {
        ArrayList<BufferedImage> imageList = new ArrayList<BufferedImage>();
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) continue;
            BufferedImage img = ImageIO.read(file);
            imageList.add(img);
        }
        return imageList;
    }

    public static HashMap<File, BufferedImage> loadFileImageMapFromDirectory(File dir) throws IOException {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("Parameter dir must be a directory: " + dir.toString());
        }
        HashMap<File, BufferedImage> imageMap = new HashMap<File, BufferedImage>();
        for (File file : dir.listFiles()) {
            String imgType;
            if (file.isDirectory() || !(imgType = ImageUtils.getImageType(file)).equalsIgnoreCase("jpg") && !imgType.equalsIgnoreCase("jpeg") && !imgType.equalsIgnoreCase("png")) continue;
            BufferedImage img = ImageIO.read(file);
            imageMap.put(file, img);
        }
        return imageMap;
    }

    public static String getImageType(File file) {
        String fileName = file.getName();
        return fileName.substring(fileName.lastIndexOf(".") + 1);
    }

    public static void createIndexFile(HashMap<File, BufferedImage> imageMap, String imageFile, boolean useAbsPath) throws IOException {
        try (BufferedWriter out = new BufferedWriter(new FileWriter(imageFile));){
            int fileCount = imageMap.size();
            int i = 0;
            for (File file : imageMap.keySet()) {
                if (!useAbsPath) {
                    out.write(file.getName());
                } else {
                    out.write(file.getPath());
                }
                if (i < fileCount - 1) {
                    out.write(System.lineSeparator());
                }
                ++i;
            }
        }
    }

    public static BufferedImage[] randomTranslateImage(BufferedImage img, int stepCount, int stepSize) {
        BufferedImage[] images = new BufferedImage[stepCount * 4];
        AffineTransform[] trans = new AffineTransform[4];
        for (int i = 0; i < stepCount; ++i) {
            trans[0] = AffineTransform.getTranslateInstance(i * stepSize, 0.0);
            trans[1] = AffineTransform.getTranslateInstance(-i * stepSize, 0.0);
            trans[2] = AffineTransform.getTranslateInstance(0.0, i * stepSize);
            trans[3] = AffineTransform.getTranslateInstance(0.0, -i * stepSize);
            for (int t = 0; t < 4; ++t) {
                BufferedImage newImage = new BufferedImage(img.getWidth(), img.getHeight(), img.getType());
                Graphics2D dispGc = newImage.createGraphics();
                dispGc.setBackground(Color.WHITE);
                dispGc.clearRect(0, 0, newImage.getWidth(), newImage.getHeight());
                dispGc.drawImage(img, trans[t], null);
                images[i * 4 + t] = newImage;
            }
        }
        return images;
    }

    public static List<BufferedImage> randomCrop(BufferedImage img, int cropWidth, int cropHeight, int cropNum, Random random) {
        ArrayList<BufferedImage> croppedImages = new ArrayList<BufferedImage>();
        int maxX = img.getWidth() - cropWidth;
        int maxY = img.getHeight() - cropHeight;
        for (int i = 0; i < cropNum; ++i) {
            int x = random.nextInt(maxX);
            int y = random.nextInt(maxY);
            BufferedImage cropped = img.getSubimage(x, y, cropWidth, cropHeight);
            croppedImages.add(cropped);
        }
        return croppedImages;
    }

    public static List<BufferedImage> randomTintAndBrightness(BufferedImage img, float maxTint, int maxBrightness, int num, Random random) {
        ArrayList<BufferedImage> augmentedImages = new ArrayList<BufferedImage>();
        for (int i = 0; i < num; ++i) {
            float k = random.nextFloat() * maxTint;
            int n = random.nextInt(maxBrightness);
            for (int y = 0; y < img.getHeight(); ++y) {
                for (int x = 0; x < img.getWidth(); ++x) {
                    int rgb = img.getRGB(x, y);
                    if ((rgb += n) > 255) {
                        rgb = 255;
                    }
                    img.setRGB(x, y, rgb);
                }
            }
            BufferedImage newImg = ImageUtils.deepCopy(img);
            augmentedImages.add(newImg);
        }
        return augmentedImages;
    }

    static BufferedImage deepCopy(BufferedImage bi) {
        ColorModel cm = bi.getColorModel();
        boolean isAlphaPremultiplied = cm.isAlphaPremultiplied();
        WritableRaster raster = bi.copyData(null);
        return new BufferedImage(cm, raster, isAlphaPremultiplied, null);
    }

    public static void writeImages(List<BufferedImage> images, String targetPath, String fileNamePrefix, String fileType) throws IOException {
        int i = 0;
        for (BufferedImage img : images) {
            ImageIO.write((RenderedImage)img, fileType, new File(targetPath + File.separator + fileNamePrefix + "_" + ++i + "." + fileType));
        }
    }

    public static void generateRandomColoredImages(int width, int height, int numberOfImages, String destPath) throws IOException {
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics gr = image.getGraphics();
        for (int i = 0; i < numberOfImages; ++i) {
            float r = (float)Math.random();
            float g = (float)Math.random();
            float b = (float)Math.random();
            gr.setColor(new Color(r, g, b));
            gr.fillRect(0, 0, width, height);
            String fileName = "negative_" + i + ".jpg";
            ImageIO.write((RenderedImage)image, "jpg", new File(destPath + "/" + fileName));
        }
    }

    public static void generateNoisyImage(int width, int height, int numberOfImages, String destPath) throws IOException {
        BufferedImage image = new BufferedImage(width, height, 2);
        for (int i = 0; i < numberOfImages; ++i) {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int a = (int)(Math.random() * 256.0);
                    int r = (int)(Math.random() * 256.0);
                    int g = (int)(Math.random() * 256.0);
                    int b = (int)(Math.random() * 256.0);
                    int color = a << 24 | r << 16 | g << 8 | b;
                    image.setRGB(x, y, color);
                }
            }
            String fileName = "noisy_" + i + ".jpg";
            ImageIO.write((RenderedImage)image, "jpg", new File(destPath + "/" + fileName));
        }
    }
}

