/*
 * Decompiled with CFR 0.152.
 */
package deepnetts.util;

import deepnetts.util.ImageUtils;
import deepnetts.util.ScaleImages;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public class RandomlyTranslateImages {
    String sourcePath = "/sourcePath/";
    String targetPath = "/sourcePath/";
    String imageIndexFileFile = "";
    String labelsFile = "";

    public void run() {
        try (BufferedWriter br = new BufferedWriter(new FileWriter(this.targetPath + "translatedImages.txt"));){
            HashMap<File, BufferedImage> images = ImageUtils.loadFileImageMapFromDirectory(new File(this.sourcePath));
            int i = 0;
            for (File file : images.keySet()) {
                if (!this.isImageFile(file)) continue;
                BufferedImage[] translatedImages = ImageUtils.randomTranslateImage(images.get(file), 2, 2);
                String fileName = file.getName();
                String name = fileName.substring(0, fileName.lastIndexOf("."));
                String imgType = fileName.substring(fileName.lastIndexOf(".") + 1);
                for (int j = 0; j < translatedImages.length; ++j) {
                    String newFileName = name + "_" + j + "." + imgType;
                    ImageIO.write((RenderedImage)translatedImages[j], imgType, new File(this.targetPath + newFileName));
                    br.write(this.targetPath + newFileName + " " + name + System.lineSeparator());
                }
                ++i;
            }
            br.close();
        }
        catch (IOException ex) {
            Logger.getLogger(ScaleImages.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public boolean isImageFile(File file) {
        String fileName = file.getName();
        if (fileName.equalsIgnoreCase("white.jpg")) {
            return false;
        }
        String type = fileName.substring(fileName.lastIndexOf("."));
        return type.equalsIgnoreCase(".jpg") || type.equalsIgnoreCase(".png");
    }

    public static void main(String[] args) {
        RandomlyTranslateImages demo = new RandomlyTranslateImages();
        demo.run();
    }
}

