/*
 * Decompiled with CFR 0.152.
 */
package deepnetts.util;

import deepnetts.util.ImageUtils;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public class ScaleImages {
    String sourcePath = "D:\\datasets\\sourcePath\\";
    String targetPath = "D:\\datasets\\targetPath\\";
    int targetWidth = 96;
    int targetHeight = 96;
    String imageIndexFileFile = "";
    String labelsFile = "";

    public void run() {
        try {
            HashMap<File, BufferedImage> images = ImageUtils.loadFileImageMapFromDirectory(new File(this.sourcePath));
            int i = 0;
            for (File file : images.keySet()) {
                BufferedImage scaledImage = ImageUtils.scaleAndCenter(images.get(file), this.targetWidth, this.targetHeight, 0, Color.WHITE);
                String fileName = file.getName();
                String imgType = fileName.substring(fileName.lastIndexOf(".") + 1);
                ImageIO.write((RenderedImage)scaledImage, imgType, new File(this.targetPath + "" + file.getName()));
                ++i;
            }
            ImageUtils.createIndexFile(images, this.targetPath + "imageIndex.txt", true);
        }
        catch (IOException ex) {
            Logger.getLogger(ScaleImages.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void main(String[] args) {
        ScaleImages demo = new ScaleImages();
        demo.run();
    }
}

