/*
 * Decompiled with CFR 0.152.
 */
package deepnetts.data.preprocessing.scale;

import deepnetts.data.MLDataItem;
import java.io.Serializable;
import javax.visrec.ml.data.DataSet;
import javax.visrec.ml.data.preprocessing.Scaler;

public class RangeScaler
implements Scaler<DataSet<MLDataItem>>,
Serializable {
    private final float min;
    private final float max;

    public RangeScaler(float min, float max) {
        this.min = min;
        this.max = max;
    }

    public void apply(DataSet<MLDataItem> dataSet) {
        float divisor = this.max - this.min;
        for (MLDataItem item : dataSet) {
            item.getInput().sub(this.min);
            item.getInput().div(divisor);
            item.getTargetOutput().sub(this.min);
            item.getTargetOutput().div(divisor);
        }
    }
}

