/*
 * Decompiled with CFR 0.152.
 */
package deepnetts.net.layers.activation;

import deepnetts.net.layers.activation.ActivationType;
import deepnetts.net.layers.activation.Linear;
import deepnetts.net.layers.activation.Relu;
import deepnetts.net.layers.activation.Sigmoid;
import deepnetts.net.layers.activation.Tanh;
import deepnetts.util.DeepNettsException;

public interface ActivationFunction {
    public float getValue(float var1);

    public float getPrime(float var1);

    public static ActivationFunction create(ActivationType type) {
        switch (type) {
            case LINEAR: {
                return new Linear();
            }
            case RELU: {
                return new Relu();
            }
            case SIGMOID: {
                return new Sigmoid();
            }
            case TANH: {
                return new Tanh();
            }
        }
        throw new DeepNettsException("Unknown activation function:" + (Object)((Object)type));
    }
}

