/*
 * Decompiled with CFR 0.152.
 */
package deepnetts.net.train.opt;

import deepnetts.net.layers.AbstractLayer;
import deepnetts.net.train.opt.MomentumOptimizer;
import deepnetts.net.train.opt.OptimizerType;
import deepnetts.net.train.opt.SgdOptimizer;
import deepnetts.util.DeepNettsException;

public interface Optimizer {
    public float calculateDeltaWeight(float var1, int ... var2);

    public float calculateDeltaBias(float var1, int var2);

    public static Optimizer create(OptimizerType type, AbstractLayer layer) {
        switch (type) {
            case SGD: {
                return new SgdOptimizer(layer);
            }
            case MOMENTUM: {
                return new MomentumOptimizer(layer);
            }
        }
        throw new DeepNettsException("Unknown optimizer:" + (Object)((Object)type));
    }
}

