/*
 * Decompiled with CFR 0.152.
 */
package deepnetts.util;

import deepnetts.util.ImageUtils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.ImageIO;

public class ObjectsOnBackgrounds {
    public static void main(String[] args) throws IOException {
        String objectSourcePath = "objectSourcePath";
        String bgSourcePath = "bgSourcePath";
        String targetPath = "targetPath";
        HashMap<File, BufferedImage> objects = ImageUtils.loadFileImageMapFromDirectory(new File(objectSourcePath));
        HashMap<File, BufferedImage> backgrounds = ImageUtils.loadFileImageMapFromDirectory(new File(bgSourcePath));
        for (Map.Entry<File, BufferedImage> objEntry : objects.entrySet()) {
            BufferedImage objImg = objEntry.getValue();
            String objName = objEntry.getKey().getName();
            String imgType = objName.substring(objName.indexOf(".") + 1);
            Iterator<Map.Entry<File, BufferedImage>> bgIter = backgrounds.entrySet().iterator();
            while (bgIter.hasNext()) {
                BufferedImage bgImg = bgIter.next().getValue();
                bgImg.getGraphics().drawImage(objImg, 0, 0, null);
                ImageIO.write((RenderedImage)bgImg, imgType, new File(targetPath + "/" + objName));
            }
        }
    }
}

