/*
 * Decompiled with CFR 0.152.
 */
package deepnetts.util;

import deepnetts.util.RandomGenerator;
import deepnetts.util.Tensor;

public class Tensors {
    public static float[] copyOf(float[] arr) {
        float[] copy = new float[arr.length];
        System.arraycopy(arr, 0, copy, 0, arr.length);
        return copy;
    }

    public static void sub(float[] arr, float val) {
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = arr[i] - val;
        }
    }

    public static void multiply(float[] arr1, float[] arr2) {
        for (int i = 0; i < arr1.length; ++i) {
            int n = i;
            arr1[n] = arr1[n] * arr2[i];
        }
    }

    private Tensors() {
    }

    public static Tensor absMax(Tensor t, Tensor max) {
        float[] tValues = t.getValues();
        float[] maxValues = max.getValues();
        for (int i = 0; i < tValues.length; ++i) {
            if (!(Math.abs(tValues[i]) > maxValues[i])) continue;
            maxValues[i] = Math.abs(tValues[i]);
        }
        return max;
    }

    public static float[] absMax(float[] arr, float[] max) {
        for (int i = 0; i < max.length; ++i) {
            if (!(Math.abs(arr[i]) > max[i])) continue;
            max[i] = Math.abs(arr[i]);
        }
        return max;
    }

    public static Tensor absMin(Tensor t, Tensor min) {
        float[] tValues = t.getValues();
        float[] minValues = min.getValues();
        for (int i = 0; i < tValues.length; ++i) {
            if (!(Math.abs(tValues[i]) < Math.abs(minValues[i]))) continue;
            minValues[i] = Math.abs(tValues[i]);
        }
        return min;
    }

    public static float[] absMin(float[] arr, float[] min) {
        for (int i = 0; i < arr.length; ++i) {
            if (!(Math.abs(arr[i]) < Math.abs(min[i]))) continue;
            min[i] = Math.abs(arr[i]);
        }
        return min;
    }

    public static void div(float[] array, float val) {
        int i = 0;
        while (i < array.length) {
            int n = i++;
            array[n] = array[n] / val;
        }
    }

    public static void div(float[] array, float[] divisor) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = array[i] / divisor[i];
        }
    }

    public static final void sub(float[] array1, float[] array2) {
        for (int i = 0; i < array1.length; ++i) {
            int n = i;
            array1[n] = array1[n] - array2[i];
        }
    }

    public static final void add(float[] array1, float[] array2) {
        for (int i = 0; i < array1.length; ++i) {
            int n = i;
            array1[n] = array1[n] + array2[i];
        }
    }

    public static Tensor zeros(int cols) {
        return new Tensor(cols, 0.0f);
    }

    public static Tensor ones(int cols) {
        return new Tensor(cols, 1.0f);
    }

    public static Tensor random(int rows, int cols) {
        Tensor tensor = new Tensor(rows, cols);
        for (int r = 0; r < tensor.getRows(); ++r) {
            for (int c = 0; c < tensor.getCols(); ++c) {
                tensor.set(r, c, RandomGenerator.getDefault().nextFloat());
            }
        }
        return tensor;
    }

    public static Tensor random(int rows, int cols, int depth) {
        Tensor tensor = new Tensor(rows, cols, depth);
        for (int z = 0; z < tensor.getDepth(); ++z) {
            for (int r = 0; r < tensor.getRows(); ++r) {
                for (int c = 0; c < tensor.getCols(); ++c) {
                    tensor.set(r, c, z, RandomGenerator.getDefault().nextFloat());
                }
            }
        }
        return tensor;
    }

    public static Tensor random(int rows, int cols, int depth, int fourthDim) {
        Tensor tensor = new Tensor(rows, cols, depth, fourthDim);
        for (int f = 0; f < tensor.getFourthDim(); ++f) {
            for (int z = 0; z < tensor.getDepth(); ++z) {
                for (int r = 0; r < tensor.getRows(); ++r) {
                    for (int c = 0; c < tensor.getCols(); ++c) {
                        tensor.set(r, c, z, f, RandomGenerator.getDefault().nextFloat());
                    }
                }
            }
        }
        return tensor;
    }
}

