/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.config;

import com.deepoove.poi.config.GramerSymbol;
import com.deepoove.poi.policy.NumbericRenderPolicy;
import com.deepoove.poi.policy.PictureRenderPolicy;
import com.deepoove.poi.policy.RenderPolicy;
import com.deepoove.poi.policy.SimpleTableRenderPolicy;
import com.deepoove.poi.policy.TextRenderPolicy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Configure {
    private Map<String, RenderPolicy> customPolicys = new HashMap<String, RenderPolicy>(6);
    private Map<Character, RenderPolicy> defaultPolicys = new HashMap<Character, RenderPolicy>(12);
    private List<Character> gramerChars = new ArrayList<Character>();

    private Configure() {
        this.plugin(GramerSymbol.TEXT.getSymbol(), new TextRenderPolicy());
        this.plugin(GramerSymbol.IMAGE.getSymbol(), new PictureRenderPolicy());
        this.plugin(GramerSymbol.TABLE.getSymbol(), new SimpleTableRenderPolicy());
        this.plugin(GramerSymbol.NUMBERIC.getSymbol(), new NumbericRenderPolicy());
    }

    public static Configure createDefault() {
        return new Configure();
    }

    public Configure plugin(char c, RenderPolicy policy) {
        this.gramerChars.add(Character.valueOf(c));
        this.defaultPolicys.put(Character.valueOf(c), policy);
        return this;
    }

    public void customPolicy(String tagName, RenderPolicy policy) {
        this.customPolicys.put(tagName, policy);
    }

    public Map<Character, RenderPolicy> getDefaultPolicys() {
        return this.defaultPolicys;
    }

    public Map<String, RenderPolicy> getCustomPolicys() {
        return this.customPolicys;
    }

    public List<Character> getGramerChars() {
        return this.gramerChars;
    }

    public RenderPolicy getCustomPolicy(String tagName) {
        return this.customPolicys.get(tagName);
    }

    public RenderPolicy getDefaultPolicy(Character sign) {
        return this.defaultPolicys.get(sign);
    }
}

