/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.policy;

import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.data.TextRenderData;
import com.deepoove.poi.policy.RenderPolicy;
import com.deepoove.poi.template.ElementTemplate;
import com.deepoove.poi.template.run.RunTemplate;
import com.deepoove.poi.util.StyleUtils;
import java.util.ArrayList;
import org.apache.poi.xwpf.usermodel.XWPFRun;

public class TextRenderPolicy
implements RenderPolicy {
    private static final String LINE_CHARACTOR = "\\n";

    @Override
    public void render(ElementTemplate eleTemplate, Object renderData, XWPFTemplate template) {
        RunTemplate runTemplate = (RunTemplate)eleTemplate;
        XWPFRun run = runTemplate.getRun();
        if (null == renderData) {
            run.setText("", 0);
            return;
        }
        TextRenderData textRenderData = null;
        textRenderData = renderData instanceof TextRenderData ? (TextRenderData)renderData : new TextRenderData(renderData.toString());
        String data = textRenderData.getText();
        StyleUtils.styleRun(run, textRenderData.getStyle());
        if (null == data) {
            data = "";
        }
        if (data.contains(LINE_CHARACTOR)) {
            int from = 0;
            int end = 0;
            ArrayList<String> lines = new ArrayList<String>();
            while (-1 != (end = data.indexOf(LINE_CHARACTOR, from))) {
                lines.add(data.substring(from, end));
                from = end + LINE_CHARACTOR.length();
            }
            lines.add(data.substring(from));
            Object[] linesArray = lines.toArray();
            run.setText(linesArray[0].toString(), 0);
            for (int i = 1; i < linesArray.length; ++i) {
                run.addBreak();
                run.setText(linesArray[i].toString());
            }
        } else {
            run.setText(data, 0);
        }
    }
}

