/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.render;

import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.config.Configure;
import com.deepoove.poi.config.Name;
import com.deepoove.poi.data.TextRenderData;
import com.deepoove.poi.exception.RenderException;
import com.deepoove.poi.policy.RenderPolicy;
import com.deepoove.poi.template.ElementTemplate;
import com.deepoove.poi.template.run.RunTemplate;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.poi.POIXMLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenderAPI {
    private static final Logger logger = LoggerFactory.getLogger(RenderAPI.class);

    public static void debug(XWPFTemplate template, Map<String, Object> datas) {
        List<ElementTemplate> all = template.getElementTemplates();
        logger.debug("Template tag number is:{}", (Object)(null == all ? 0 : all.size()));
        if ((all == null || all.isEmpty()) && (null == datas || datas.isEmpty())) {
            logger.debug("No template gramer find and no render data find");
            return;
        }
        HashSet<String> tagtKeys = new HashSet<String>();
        for (ElementTemplate ele : all) {
            logger.debug("Parse the tag\uff1a{}", (Object)ele.getTagName());
            tagtKeys.add(ele.getTagName());
        }
        Set<String> keySet = datas.keySet();
        HashSet<String> copySet = new HashSet<String>(keySet);
        copySet.removeAll(tagtKeys);
        for (String key : copySet) {
            logger.warn("Cannot find the gramer tag in template:" + key);
        }
        tagtKeys.removeAll(keySet);
        for (String key : tagtKeys) {
            logger.warn("Cannot find the feild in java Map or Object:" + key);
        }
    }

    public static void debug(XWPFTemplate template, Object datas) {
        RenderAPI.debug(template, RenderAPI.convert2Map(datas));
    }

    public static void selfRender(XWPFTemplate template) {
        if (null == template) {
            throw new POIXMLException("Template is null,should be setted first.");
        }
        List<ElementTemplate> elementTemplates = template.getElementTemplates();
        if (null == elementTemplates || elementTemplates.isEmpty()) {
            return;
        }
        RenderPolicy policy = null;
        for (ElementTemplate runTemplate : elementTemplates) {
            logger.debug("TagName:{}, Sign:{}", (Object)runTemplate.getTagName(), (Object)runTemplate.getSign());
            policy = template.getConfig().getDefaultPolicys().get(Character.valueOf('\u0000'));
            policy.render(runTemplate, new TextRenderData(runTemplate.getSource()), template);
        }
    }

    public static void render(XWPFTemplate template, Map<String, Object> datas) {
        if (null == template) {
            throw new POIXMLException("template is null,should be setted first.");
        }
        List<ElementTemplate> elementTemplates = template.getElementTemplates();
        if (null == elementTemplates || elementTemplates.isEmpty() || null == datas || datas.isEmpty()) {
            return;
        }
        Configure config = template.getConfig();
        RenderPolicy policy = null;
        for (ElementTemplate runTemplate : elementTemplates) {
            logger.debug("TagName:{}, Sign:{}", (Object)runTemplate.getTagName(), (Object)runTemplate.getSign());
            policy = config.getCustomPolicy(runTemplate.getTagName());
            if (null == policy && runTemplate instanceof RunTemplate) {
                Character sign = runTemplate.getSign();
                policy = config.getDefaultPolicy(sign);
            }
            if (null == policy) {
                throw new RenderException("cannot find render policy: [" + runTemplate.getTagName() + "]");
            }
            policy.render(runTemplate, datas.get(runTemplate.getTagName()), template);
        }
    }

    public static void render(XWPFTemplate template, Object dataSrouce) {
        RenderAPI.render(template, RenderAPI.convert2Map(dataSrouce));
    }

    private static Map<String, Object> convert2Map(Object dataSrouce) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        try {
            for (Class<?> clazz = dataSrouce.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
                Field[] fields = clazz.getDeclaredFields();
                PropertyDescriptor pd = null;
                for (Field f : fields) {
                    pd = new PropertyDescriptor(f.getName(), dataSrouce.getClass());
                    Name annotation = f.getAnnotation(Name.class);
                    Object value = pd.getReadMethod().invoke(dataSrouce, new Object[0]);
                    ret.put(null == annotation ? f.getName() : annotation.value(), value);
                }
            }
        }
        catch (Exception e) {
            logger.error("Convert datasource failed.", (Throwable)e);
            throw new RenderException("Convert datasource failed.");
        }
        return ret;
    }
}

