/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlToken;
import org.openxmlformats.schemas.drawingml.x2006.main.CTNonVisualDrawingProps;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPositiveSize2D;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.CTInline;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHMerge;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTbl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTcPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTVMerge;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STMerge;

public class NiceXWPFDocument
extends XWPFDocument {
    public NiceXWPFDocument() {
    }

    public NiceXWPFDocument(InputStream in) throws IOException {
        super(in);
    }

    public void mergeCellsHorizonal(XWPFTable table, int row, int fromCol, int toCol) {
        for (int colIndex = fromCol; colIndex <= toCol; ++colIndex) {
            XWPFTableCell cell = table.getRow(row).getCell(colIndex);
            CTTcPr tcPr = cell.getCTTc().getTcPr();
            if (null == tcPr) {
                tcPr = cell.getCTTc().addNewTcPr();
            }
            CTHMerge hMerge = tcPr.addNewHMerge();
            if (colIndex == fromCol) {
                hMerge.setVal(STMerge.RESTART);
                continue;
            }
            hMerge.setVal(STMerge.CONTINUE);
        }
    }

    public void mergeCellsVertically(XWPFTable table, int col, int fromRow, int toRow) {
        for (int rowIndex = fromRow; rowIndex <= toRow; ++rowIndex) {
            XWPFTableCell cell = table.getRow(rowIndex).getCell(col);
            CTTcPr tcPr = cell.getCTTc().getTcPr();
            if (null == tcPr) {
                tcPr = cell.getCTTc().addNewTcPr();
            }
            CTVMerge vMerge = tcPr.addNewVMerge();
            if (rowIndex == fromRow) {
                vMerge.setVal(STMerge.RESTART);
                continue;
            }
            vMerge.setVal(STMerge.CONTINUE);
        }
    }

    @Deprecated
    public void spanCellsAcrossRow(XWPFTable table, int rowNum, int colNum, int span) {
        XWPFTableCell cell = table.getRow(rowNum).getCell(colNum);
        cell.getCTTc().getTcPr().addNewGridSpan();
        cell.getCTTc().getTcPr().getGridSpan().setVal(BigInteger.valueOf(span));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XWPFTable insertNewTable(XWPFRun run, int row, int col) {
        XmlCursor cursor = ((XWPFParagraph)run.getParent()).getCTP().newCursor();
        if (this.isCursorInBody(cursor)) {
            String uri = CTTbl.type.getName().getNamespaceURI();
            String localPart = "tbl";
            cursor.beginElement(localPart, uri);
            cursor.toParent();
            CTTbl t = (CTTbl)cursor.getObject();
            XWPFTable newT = new XWPFTable(t, (IBody)this, row, col);
            XmlObject o = null;
            while (!(o instanceof CTTbl) && cursor.toPrevSibling()) {
                o = cursor.getObject();
            }
            if (!(o instanceof CTTbl)) {
                this.tables.add(0, newT);
            } else {
                int pos = this.tables.indexOf(this.getTable((CTTbl)o)) + 1;
                this.tables.add(pos, newT);
            }
            int i = 0;
            XmlCursor tableCursor = t.newCursor();
            try {
                cursor.toCursor(tableCursor);
                while (cursor.toPrevSibling()) {
                    o = cursor.getObject();
                    if (!(o instanceof CTP) && !(o instanceof CTTbl)) continue;
                    ++i;
                }
                this.bodyElements.add(i, newT);
                cursor.toCursor(tableCursor);
                cursor.toEndToken();
                XWPFTable xWPFTable = newT;
                return xWPFTable;
            }
            finally {
                tableCursor.dispose();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XWPFParagraph insertNewParagraph(XWPFRun run) {
        XmlCursor cursor = ((XWPFParagraph)run.getParent()).getCTP().newCursor();
        if (this.isCursorInBody(cursor)) {
            String uri = CTP.type.getName().getNamespaceURI();
            String localPart = "p";
            cursor.beginElement(localPart, uri);
            cursor.toParent();
            CTP p = (CTP)cursor.getObject();
            XWPFParagraph newP = new XWPFParagraph(p, (IBody)this);
            XmlObject o = null;
            while (!(o instanceof CTP) && cursor.toPrevSibling()) {
                o = cursor.getObject();
            }
            if (!(o instanceof CTP) || (CTP)o == p) {
                this.paragraphs.add(0, newP);
            } else {
                int pos = this.paragraphs.indexOf(this.getParagraph((CTP)o)) + 1;
                this.paragraphs.add(pos, newP);
            }
            XmlCursor newParaPos = p.newCursor();
            try {
                int i = 0;
                cursor.toCursor(newParaPos);
                while (cursor.toPrevSibling()) {
                    o = cursor.getObject();
                    if (!(o instanceof CTP) && !(o instanceof CTTbl)) continue;
                    ++i;
                }
                this.bodyElements.add(i, newP);
                cursor.toCursor(newParaPos);
                cursor.toEndToken();
                XWPFParagraph xWPFParagraph = newP;
                return xWPFParagraph;
            }
            finally {
                newParaPos.dispose();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCursorInBody(XmlCursor cursor) {
        XmlCursor verify = cursor.newCursor();
        verify.toParent();
        try {
            boolean bl = true;
            return bl;
        }
        finally {
            verify.dispose();
        }
    }

    public void createPicture(String blipId, int id, int width, int height) {
        this.addPicture(blipId, id, width, height, this.createParagraph().createRun());
    }

    public void addPicture(String blipId, int id, int width, int height, XWPFRun run) {
        int EMU = 9525;
        CTInline inline = run.getCTR().addNewDrawing().addNewInline();
        String picXml = "<a:graphic xmlns:a=\"http://schemas.openxmlformats.org/drawingml/2006/main\">   <a:graphicData uri=\"http://schemas.openxmlformats.org/drawingml/2006/picture\">      <pic:pic xmlns:pic=\"http://schemas.openxmlformats.org/drawingml/2006/picture\">         <pic:nvPicPr>            <pic:cNvPr id=\"" + id + "\" name=\"Generated\"/>            <pic:cNvPicPr/>         </pic:nvPicPr>         <pic:blipFill>            <a:blip r:embed=\"" + blipId + "\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\"/>            <a:stretch>               <a:fillRect/>            </a:stretch>         </pic:blipFill>         <pic:spPr>            <a:xfrm>               <a:off x=\"0\" y=\"0\"/>               <a:ext cx=\"" + (width *= 9525) + "\" cy=\"" + (height *= 9525) + "\"/>            </a:xfrm>            <a:prstGeom prst=\"rect\">               <a:avLst/>            </a:prstGeom>         </pic:spPr>      </pic:pic>   </a:graphicData></a:graphic>";
        XmlToken xmlToken = null;
        try {
            xmlToken = XmlToken.Factory.parse((String)picXml);
        }
        catch (XmlException xe) {
            xe.printStackTrace();
        }
        inline.set((XmlObject)xmlToken);
        inline.setDistT(0L);
        inline.setDistB(0L);
        inline.setDistL(0L);
        inline.setDistR(0L);
        CTPositiveSize2D extent = inline.addNewExtent();
        extent.setCx((long)width);
        extent.setCy((long)height);
        CTNonVisualDrawingProps docPr = inline.addNewDocPr();
        docPr.setId((long)id);
        docPr.setName("Picture " + id);
        docPr.setDescr("Generated");
    }
}

