/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.policy;

import com.deepoove.poi.NiceXWPFDocument;
import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.data.RenderData;
import com.deepoove.poi.data.TableRenderData;
import com.deepoove.poi.data.TextRenderData;
import com.deepoove.poi.data.style.Style;
import com.deepoove.poi.policy.RenderPolicy;
import com.deepoove.poi.template.ElementTemplate;
import com.deepoove.poi.template.run.RunTemplate;
import java.math.BigInteger;
import java.util.List;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblWidth;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STTblWidth;

public class SimpleTableRenderPolicy
implements RenderPolicy {
    @Override
    public void render(ElementTemplate eleTemplate, Object data, XWPFTemplate template) {
        NiceXWPFDocument doc = template.getXWPFDocument();
        RunTemplate runTemplate = (RunTemplate)eleTemplate;
        XWPFRun run = runTemplate.getRun();
        if (null == data) {
            return;
        }
        TableRenderData tableData = (TableRenderData)data;
        List<RenderData> headers = tableData.getHeaders();
        List<Object> datas = tableData.getDatas();
        if (datas == null || datas.isEmpty()) {
            if (headers == null || headers.isEmpty()) {
                runTemplate.getRun().setText("", 0);
                return;
            }
            XWPFTable table = doc.insertNewTable(run, 2, headers.size());
            if (null == table) {
                logger.warn("cannot insert table.");
                return;
            }
            this.widthTable(table, tableData.getWidth());
            this.createHeader(table, headers);
            doc.mergeCellsHorizonal(table, 1, 0, headers.size() - 1);
            XWPFTableCell cell = table.getRow(1).getCell(0);
            cell.setText(tableData.getNoDatadesc());
        } else {
            int maxColom = 0;
            int row = datas.size();
            int startRow = 1;
            if (headers == null || headers.isEmpty()) {
                startRow = 0;
                maxColom = this.getMaxColumFromData(datas);
            } else {
                ++row;
                maxColom = headers.size();
            }
            XWPFTable table = doc.insertNewTable(run, row, maxColom);
            this.widthTable(table, tableData.getWidth());
            this.createHeader(table, headers);
            for (Object obj : datas) {
                if (null == obj) continue;
                String str = obj.toString();
                String[] split = str.split(";");
                int length = split.length;
                for (int m = 0; m < length; ++m) {
                    table.getRow(startRow).getCell(m).setText(split[m]);
                }
                ++startRow;
            }
        }
        runTemplate.getRun().setText("", 0);
    }

    private void widthTable(XWPFTable table, int width) {
        CTTblWidth tblW;
        CTTblPr tblPr = table.getCTTbl().getTblPr();
        if (null == tblPr) {
            tblPr = table.getCTTbl().addNewTblPr();
        }
        if ((tblW = tblPr.getTblW()) == null) {
            tblW = tblPr.addNewTblW();
        }
        tblW.setType(STTblWidth.DXA);
        tblW.setW(BigInteger.valueOf(width));
    }

    private int getMaxColumFromData(List<Object> datas) {
        int maxColom = 0;
        for (Object obj : datas) {
            String str;
            String[] split;
            if (null == obj || (split = (str = obj.toString()).split(";")).length <= maxColom) continue;
            maxColom = split.length;
        }
        return maxColom;
    }

    private void createHeader(XWPFTable table, List<RenderData> headers) {
        if (null == headers || headers.isEmpty()) {
            return;
        }
        int i = 0;
        for (RenderData head : headers) {
            TextRenderData textHead = (TextRenderData)head;
            Style style = textHead.getStyle();
            String color = null == style ? null : style.getColor();
            table.getRow(0).getCell(i).setText(textHead.getText());
            if (null != color) {
                table.getRow(0).getCell(i).setColor(color);
            }
            ++i;
        }
    }
}

