/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.resolver;

import com.deepoove.poi.NiceXWPFDocument;
import com.deepoove.poi.config.Configure;
import com.deepoove.poi.resolver.RunEdge;
import com.deepoove.poi.resolver.TemplateFactory;
import com.deepoove.poi.template.ElementTemplate;
import com.deepoove.poi.template.run.RunTemplate;
import com.deepoove.poi.util.RegexUtils;
import com.deepoove.poi.util.StyleUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.poi.xwpf.usermodel.XWPFFooter;
import org.apache.poi.xwpf.usermodel.XWPFHeader;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(TemplateResolver.class);
    public final String RULER_REGEX;
    public final String EXTRA_REGEX;
    public final Pattern TAG_PATTERN;
    public final Pattern VAR_PATTERN;
    public Configure config;

    public TemplateResolver(Configure config) {
        String signRegex = this.getGramarRegex(config);
        String prefixRegex = RegexUtils.escapeExprSpecialWord("{{");
        String suffixRegex = RegexUtils.escapeExprSpecialWord("}}");
        this.RULER_REGEX = MessageFormat.format("{0}{1}\\w+{2}", prefixRegex, signRegex, suffixRegex);
        this.EXTRA_REGEX = MessageFormat.format("({0})|({1})", prefixRegex, suffixRegex);
        this.TAG_PATTERN = Pattern.compile(this.RULER_REGEX);
        this.VAR_PATTERN = Pattern.compile(this.EXTRA_REGEX);
        this.config = config;
    }

    public List<ElementTemplate> parseElementTemplates(NiceXWPFDocument doc) {
        if (null == doc) {
            return null;
        }
        ArrayList<ElementTemplate> rts = new ArrayList<ElementTemplate>();
        rts.addAll(this.parseParagraph(doc.getParagraphs()));
        rts.addAll(this.parseTable(doc.getTables()));
        rts.addAll(this.parseHeader(doc.getHeaderList()));
        rts.addAll(this.parseFooter(doc.getFooterList()));
        return rts;
    }

    public List<ElementTemplate> parseHeader(List<XWPFHeader> headers) {
        ArrayList<ElementTemplate> result = new ArrayList<ElementTemplate>();
        if (null != headers) {
            for (XWPFHeader header : headers) {
                result.addAll(this.parseParagraph(header.getParagraphs()));
                result.addAll(this.parseTable(header.getTables()));
            }
        }
        return result;
    }

    public List<ElementTemplate> parseFooter(List<XWPFFooter> footers) {
        ArrayList<ElementTemplate> result = new ArrayList<ElementTemplate>();
        if (null != footers) {
            for (XWPFFooter footer : footers) {
                result.addAll(this.parseParagraph(footer.getParagraphs()));
                result.addAll(this.parseTable(footer.getTables()));
            }
        }
        return result;
    }

    public List<RunTemplate> parseParagraph(List<XWPFParagraph> paragraphs) {
        ArrayList<RunTemplate> result = new ArrayList<RunTemplate>();
        if (null != paragraphs && !paragraphs.isEmpty()) {
            for (XWPFParagraph paragraph : paragraphs) {
                List<RunTemplate> parseRun = this.parseRun(paragraph);
                if (null == parseRun) continue;
                result.addAll(parseRun);
            }
        }
        return result;
    }

    public List<ElementTemplate> parseTable(List<XWPFTable> tables) {
        ArrayList<ElementTemplate> result = new ArrayList<ElementTemplate>();
        if (null != tables && !tables.isEmpty()) {
            for (XWPFTable tb : tables) {
                List<ElementTemplate> parseTable = this.parseTable(tb);
                if (null == parseTable) continue;
                result.addAll(parseTable);
            }
        }
        return result;
    }

    public List<ElementTemplate> parseTable(XWPFTable table) {
        if (null == table) {
            return null;
        }
        List rows = table.getRows();
        if (null == rows) {
            return null;
        }
        ArrayList<ElementTemplate> rts = new ArrayList<ElementTemplate>();
        for (XWPFTableRow row : rows) {
            List cells = row.getTableCells();
            if (null == cells) continue;
            for (XWPFTableCell cell : cells) {
                rts.addAll(this.parseParagraph(cell.getParagraphs()));
                rts.addAll(this.parseTable(cell.getTables()));
            }
        }
        return rts;
    }

    public List<RunTemplate> parseRun(XWPFParagraph paragraph) {
        int n;
        if (null == paragraph) {
            return null;
        }
        List runs = paragraph.getRuns();
        if (null == runs || runs.isEmpty()) {
            return null;
        }
        String text = paragraph.getText();
        LOGGER.debug("The Paragrah's text is:{}", (Object)text);
        ArrayList<Pair<RunEdge, RunEdge>> runEdgeListPairs = new ArrayList<Pair<RunEdge, RunEdge>>();
        ArrayList<String> tags = new ArrayList<String>();
        Matcher matcher = this.TAG_PATTERN.matcher(text);
        while (matcher.find()) {
            tags.add(matcher.group());
            runEdgeListPairs.add((Pair<RunEdge, RunEdge>)ImmutablePair.of((Object)new RunEdge(matcher.start(), matcher.group()), (Object)new RunEdge(matcher.end(), matcher.group())));
        }
        if (tags.isEmpty()) {
            return null;
        }
        this.searchRunEdge(runs, runEdgeListPairs);
        for (Pair pair : runEdgeListPairs) {
            LOGGER.debug(((RunEdge)pair.getLeft()).toString());
            LOGGER.debug(((RunEdge)pair.getRight()).toString());
        }
        ArrayList<RunTemplate> rts = new ArrayList<RunTemplate>();
        int tagIndex = n = runEdgeListPairs.size();
        for (int n2 = n - 1; n2 >= 0; --n2) {
            RunTemplate runTemplate;
            XWPFRun extraRun;
            String extra;
            Pair runEdgePair = (Pair)runEdgeListPairs.get(n2);
            RunEdge startEdge = (RunEdge)runEdgePair.getLeft();
            RunEdge endEdge = (RunEdge)runEdgePair.getRight();
            int startRunPos = startEdge.getRunPos();
            int endRunPos = endEdge.getRunPos();
            int startOffset = startEdge.getRunEdge();
            int endOffset = endEdge.getRunEdge();
            String startText = ((XWPFRun)runs.get(startRunPos)).getText(0);
            String endText = ((XWPFRun)runs.get(endRunPos)).getText(0);
            if (endOffset + 1 >= endText.length()) {
                if (startRunPos != endRunPos) {
                    paragraph.removeRun(endRunPos);
                }
            } else {
                extra = endText.substring(endOffset + 1, endText.length());
                if (startRunPos == endRunPos) {
                    extraRun = paragraph.insertNewRun(endRunPos + 1);
                    StyleUtils.styleRun(extraRun, (XWPFRun)runs.get(endRunPos));
                    extraRun.setText(extra, 0);
                } else {
                    extraRun = (XWPFRun)runs.get(endRunPos);
                    extraRun.setText(extra, 0);
                }
            }
            for (int m = endRunPos - 1; m > startRunPos; --m) {
                paragraph.removeRun(m);
            }
            if (startOffset <= 0) {
                XWPFRun templateRun = (XWPFRun)runs.get(startRunPos);
                templateRun.setText((String)tags.get(--tagIndex), 0);
                runTemplate = this.parseRun((XWPFRun)runs.get(startRunPos));
            } else {
                extra = startText.substring(0, startOffset);
                extraRun = (XWPFRun)runs.get(startRunPos);
                extraRun.setText(extra, 0);
                XWPFRun templateRun = paragraph.insertNewRun(startRunPos + 1);
                StyleUtils.styleRun(templateRun, extraRun);
                templateRun.setText((String)tags.get(--tagIndex), 0);
                runTemplate = this.parseRun((XWPFRun)runs.get(startRunPos + 1));
            }
            if (null == runTemplate) continue;
            rts.add(runTemplate);
        }
        return rts;
    }

    private void searchRunEdge(List<XWPFRun> runs, List<Pair<RunEdge, RunEdge>> pairs) {
        int size = runs.size();
        int cursor = 0;
        int pos = 0;
        Pair<RunEdge, RunEdge> pair = pairs.get(pos);
        RunEdge startEdge = (RunEdge)pair.getLeft();
        RunEdge endEdge = (RunEdge)pair.getRight();
        int start = startEdge.getAllPos();
        int end = endEdge.getAllPos();
        for (int i = 0; i < size; ++i) {
            XWPFRun run = runs.get(i);
            String text = run.getText(0);
            if (null == text) {
                LOGGER.warn("found the empty text run,may be produce bug:" + run);
                cursor += run.toString().length();
                continue;
            }
            LOGGER.debug(text);
            if (text.length() + cursor < start) {
                cursor += text.length();
                continue;
            }
            for (int offset = 0; offset < text.length(); ++offset) {
                if (cursor + offset == start) {
                    startEdge.setRunPos(i);
                    startEdge.setRunEdge(offset);
                    startEdge.setText(text);
                }
                if (cursor + offset != end - 1) continue;
                endEdge.setRunPos(i);
                endEdge.setRunEdge(offset);
                endEdge.setText(text);
                if (pos == pairs.size() - 1) break;
                pair = pairs.get(++pos);
                startEdge = (RunEdge)pair.getLeft();
                endEdge = (RunEdge)pair.getRight();
                start = startEdge.getAllPos();
                end = endEdge.getAllPos();
            }
            cursor += text.length();
        }
    }

    public RunTemplate parseRun(XWPFRun run) {
        String text = null;
        if (null == run || StringUtils.isBlank((CharSequence)(text = run.getText(0)))) {
            return null;
        }
        return (RunTemplate)this.parseTemplateFactory(text, run);
    }

    private <T> ElementTemplate parseTemplateFactory(String text, T obj) {
        LOGGER.debug("parse text:" + text);
        if (this.TAG_PATTERN.matcher(text).matches()) {
            String tag = this.VAR_PATTERN.matcher(text).replaceAll("").trim();
            if (obj.getClass() == XWPFRun.class) {
                return TemplateFactory.createRunTemplate(tag, this.config.getGramerChars(), (XWPFRun)obj);
            }
            if (obj.getClass() == XWPFTableCell.class) {
                return null;
            }
        }
        return null;
    }

    private String getGramarRegex(Configure config) {
        String escapeExprSpecialWord;
        List<Character> gramerChar = config.getGramerChars();
        StringBuffer reg = new StringBuffer("(");
        int i = 0;
        while (true) {
            Character chara = gramerChar.get(i);
            escapeExprSpecialWord = RegexUtils.escapeExprSpecialWord(chara.toString());
            if (i == gramerChar.size() - 1) break;
            reg.append(escapeExprSpecialWord).append("|");
            ++i;
        }
        reg.append(escapeExprSpecialWord).append(")?");
        return reg.toString();
    }
}

