/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.util;

import com.deepoove.poi.data.style.Style;
import java.math.BigInteger;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTColor;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFonts;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHpsMeasure;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTOnOff;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTParaRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STOnOff;

public final class StyleUtils {
    public static void styleRun(XWPFRun run, Style style) {
        if (null == run || null == style) {
            return;
        }
        String color = style.getColor();
        String fontFamily = style.getFontFamily();
        int fontSize = style.getFontSize();
        Boolean bold = style.isBold();
        Boolean italic = style.isItalic();
        Boolean strike = style.isStrike();
        if (null != color) {
            run.setColor(color);
        }
        if (0 != fontSize) {
            run.setFontSize(fontSize);
        }
        if (null != fontFamily) {
            run.setFontFamily(fontFamily);
        }
        if (null != bold) {
            run.setBold(bold.booleanValue());
        }
        if (null != italic) {
            run.setItalic(italic.booleanValue());
        }
        if (null != strike) {
            run.setStrikeThrough(strike.booleanValue());
        }
    }

    public static void styleRun(XWPFRun destRun, XWPFRun srcRun) {
        if (null == destRun || null == srcRun) {
            return;
        }
        destRun.setBold(srcRun.isBold());
        destRun.setColor(srcRun.getColor());
        destRun.setFontFamily(srcRun.getFontFamily());
        int fontSize = srcRun.getFontSize();
        if (-1 != fontSize) {
            destRun.setFontSize(fontSize);
        }
        destRun.setItalic(srcRun.isItalic());
        destRun.setStrikeThrough(srcRun.isStrikeThrough());
        destRun.setUnderline(srcRun.getUnderline());
    }

    public static void styleRpr(CTParaRPr pr, Style fmtStyle) {
        if (null == pr || null == fmtStyle) {
            return;
        }
        if (null != fmtStyle.getColor()) {
            CTColor color = pr.isSetColor() ? pr.getColor() : pr.addNewColor();
            color.setVal((Object)fmtStyle.getColor());
        }
        if (null != fmtStyle.isItalic()) {
            CTOnOff italic = pr.isSetI() ? pr.getI() : pr.addNewI();
            italic.setVal(fmtStyle.isItalic() != false ? STOnOff.TRUE : STOnOff.FALSE);
        }
        if (null != fmtStyle.isBold()) {
            CTOnOff bold = pr.isSetB() ? pr.getB() : pr.addNewB();
            bold.setVal(fmtStyle.isBold() != false ? STOnOff.TRUE : STOnOff.FALSE);
        }
        if (0 != fmtStyle.getFontSize()) {
            BigInteger bint = new BigInteger("" + fmtStyle.getFontSize());
            CTHpsMeasure ctSize = pr.isSetSz() ? pr.getSz() : pr.addNewSz();
            ctSize.setVal(bint.multiply(new BigInteger("2")));
        }
        if (null != fmtStyle.isStrike()) {
            CTOnOff strike = pr.isSetStrike() ? pr.getStrike() : pr.addNewStrike();
            strike.setVal(fmtStyle.isStrike() != false ? STOnOff.TRUE : STOnOff.FALSE);
        }
        if (null != fmtStyle.getFontFamily()) {
            CTFonts fonts = pr.isSetRFonts() ? pr.getRFonts() : pr.addNewRFonts();
            String fontFamily = fmtStyle.getFontFamily();
            fonts.setAscii(fontFamily);
            if (!fonts.isSetHAnsi()) {
                fonts.setHAnsi(fontFamily);
            }
            if (!fonts.isSetCs()) {
                fonts.setCs(fontFamily);
            }
            if (!fonts.isSetEastAsia()) {
                fonts.setEastAsia(fontFamily);
            }
        }
    }
}

