/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.xwpf;

import com.deepoove.poi.plugin.comment.XWPFComments;
import com.deepoove.poi.xwpf.NiceXWPFDocument;
import com.deepoove.poi.xwpf.XWPFTextboxContent;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.ooxml.POIXMLDocumentPart;
import org.apache.poi.ooxml.POIXMLException;
import org.apache.poi.ooxml.POIXMLTypeLoader;
import org.apache.poi.ooxml.util.DocumentHelper;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.xwpf.usermodel.IRunBody;
import org.apache.poi.xwpf.usermodel.XWPFPicture;
import org.apache.poi.xwpf.usermodel.XWPFPictureData;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.XmlToken;
import org.apache.xmlbeans.impl.values.XmlAnyTypeImpl;
import org.openxmlformats.schemas.drawingml.x2006.main.CTBlip;
import org.openxmlformats.schemas.drawingml.x2006.main.CTBlipFillProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGraphicalObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGraphicalObjectData;
import org.openxmlformats.schemas.drawingml.x2006.main.CTNonVisualDrawingProps;
import org.openxmlformats.schemas.drawingml.x2006.main.CTNonVisualPictureProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPoint2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPositiveSize2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPresetGeometry2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTShapeProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTransform2D;
import org.openxmlformats.schemas.drawingml.x2006.main.STShapeType;
import org.openxmlformats.schemas.drawingml.x2006.picture.CTPicture;
import org.openxmlformats.schemas.drawingml.x2006.picture.CTPictureNonVisual;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.CTInline;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDrawing;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPicture;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTR;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTxbxContent;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XWPFRunWrapper {
    public static final String XPATH_TXBX_TXBXCONTENT = "declare namespace w='http://schemas.openxmlformats.org/wordprocessingml/2006/main' \n        declare namespace mc='http://schemas.openxmlformats.org/markup-compatibility/2006' .//mc:Choice/*/w:txbxContent";
    public static final String XPATH_TEXTBOX_TXBXCONTENT = "declare namespace w='http://schemas.openxmlformats.org/wordprocessingml/2006/main' \n        declare namespace mc='http://schemas.openxmlformats.org/markup-compatibility/2006' .//mc:Fallback/*/w:txbxContent";
    public static final String XPATH_PICT_TEXTBOX_TXBXCONTENT = "declare namespace w='http://schemas.openxmlformats.org/wordprocessingml/2006/main' \n        declare namespace v='urn:schemas-microsoft-com:vml' ./v:shape/v:textbox/w:txbxContent";
    private final XWPFRun run;
    private XWPFTextboxContent wpstxbx;
    private XWPFTextboxContent vtextbox;
    private XWPFTextboxContent shapetxbx;

    public XWPFRunWrapper(XWPFRun run) {
        this(run, true);
    }

    public XWPFRunWrapper(XWPFRun run, boolean isParse) {
        CTPicture ctPicture;
        CTTxbxContent ctTxbxContent2;
        this.run = run;
        if (!isParse) {
            return;
        }
        CTR r = run.getCTR();
        XmlObject[] xmlObjects = r.selectPath(XPATH_TXBX_TXBXCONTENT);
        if (xmlObjects != null && xmlObjects.length >= 1) {
            try {
                ctTxbxContent2 = CTTxbxContent.Factory.parse((String)xmlObjects[0].xmlText());
                this.wpstxbx = new XWPFTextboxContent(ctTxbxContent2, run, run.getParagraph().getBody(), xmlObjects[0]);
            }
            catch (XmlException ctTxbxContent2) {
                // empty catch block
            }
        }
        if ((xmlObjects = r.selectPath(XPATH_TEXTBOX_TXBXCONTENT)) != null && xmlObjects.length >= 1) {
            try {
                ctTxbxContent2 = CTTxbxContent.Factory.parse((String)xmlObjects[0].xmlText());
                this.vtextbox = new XWPFTextboxContent(ctTxbxContent2, run, run.getParagraph().getBody(), xmlObjects[0]);
            }
            catch (XmlException ctTxbxContent3) {
                // empty catch block
            }
        }
        CTPicture cTPicture = ctPicture = CollectionUtils.isNotEmpty((Collection)r.getPictList()) ? r.getPictArray(0) : null;
        if (null != ctPicture && (xmlObjects = ctPicture.selectPath(XPATH_PICT_TEXTBOX_TXBXCONTENT)) != null && xmlObjects.length >= 1) {
            try {
                CTTxbxContent ctTxbxContent4 = null;
                ctTxbxContent4 = xmlObjects[0] instanceof CTTxbxContent ? (CTTxbxContent)xmlObjects[0] : CTTxbxContent.Factory.parse((String)xmlObjects[0].xmlText());
                this.shapetxbx = new XWPFTextboxContent(ctTxbxContent4, run, run.getParagraph().getBody(), xmlObjects[0]);
            }
            catch (XmlException xmlException) {
                // empty catch block
            }
        }
    }

    public XWPFRun getRun() {
        return this.run;
    }

    public XWPFTextboxContent getWpstxbx() {
        return this.wpstxbx;
    }

    public XWPFTextboxContent getVtextbox() {
        return this.vtextbox;
    }

    public XWPFTextboxContent getShapetxbx() {
        return this.shapetxbx;
    }

    public XWPFPicture addPicture(InputStream pictureData, int pictureType, String filename, int width, int height) throws InvalidFormatException, Exception {
        IRunBody parent = this.run.getParent();
        if (!(parent.getPart() instanceof XWPFComments)) {
            return this.run.addPicture(pictureData, pictureType, filename, width, height);
        }
        XWPFComments comments = (XWPFComments)parent.getPart();
        String relationId = comments.addPictureData(pictureData, pictureType);
        XWPFPictureData picData = (XWPFPictureData)comments.getRelationById(relationId);
        try {
            CTDrawing drawing = this.run.getCTR().addNewDrawing();
            CTInline inline = drawing.addNewInline();
            String xml = "<a:graphic xmlns:a=\"" + CTGraphicalObject.type.getName().getNamespaceURI() + "\"><a:graphicData uri=\"" + org.openxmlformats.schemas.drawingml.x2006.picture.CTPicture.type.getName().getNamespaceURI() + "\"><pic:pic xmlns:pic=\"" + org.openxmlformats.schemas.drawingml.x2006.picture.CTPicture.type.getName().getNamespaceURI() + "\" /></a:graphicData></a:graphic>";
            InputSource is = new InputSource(new StringReader(xml));
            Document doc = DocumentHelper.readDocument((InputSource)is);
            inline.set((XmlObject)XmlToken.Factory.parse((Node)doc.getDocumentElement(), (XmlOptions)POIXMLTypeLoader.DEFAULT_XML_OPTIONS));
            inline.setDistT(0L);
            inline.setDistR(0L);
            inline.setDistB(0L);
            inline.setDistL(0L);
            CTNonVisualDrawingProps docPr = inline.addNewDocPr();
            long id = ((NiceXWPFDocument)this.run.getParent().getDocument()).getDocPrIdenifierManager().reserveNew();
            docPr.setId(id);
            docPr.setName("Drawing " + id);
            docPr.setDescr(filename);
            CTPositiveSize2D extent = inline.addNewExtent();
            extent.setCx((long)width);
            extent.setCy((long)height);
            CTGraphicalObject graphic = inline.getGraphic();
            CTGraphicalObjectData graphicData = graphic.getGraphicData();
            org.openxmlformats.schemas.drawingml.x2006.picture.CTPicture pic = this.getCTPictures((XmlObject)graphicData).get(0);
            CTPictureNonVisual nvPicPr = pic.addNewNvPicPr();
            CTNonVisualDrawingProps cNvPr = nvPicPr.addNewCNvPr();
            cNvPr.setId(0L);
            cNvPr.setName("Picture " + id);
            cNvPr.setDescr(filename);
            CTNonVisualPictureProperties cNvPicPr = nvPicPr.addNewCNvPicPr();
            cNvPicPr.addNewPicLocks().setNoChangeAspect(true);
            CTBlipFillProperties blipFill = pic.addNewBlipFill();
            CTBlip blip = blipFill.addNewBlip();
            blip.setEmbed(parent.getPart().getRelationId((POIXMLDocumentPart)picData));
            blipFill.addNewStretch().addNewFillRect();
            CTShapeProperties spPr = pic.addNewSpPr();
            CTTransform2D xfrm = spPr.addNewXfrm();
            CTPoint2D off = xfrm.addNewOff();
            off.setX(0L);
            off.setY(0L);
            CTPositiveSize2D ext = xfrm.addNewExt();
            ext.setCx((long)width);
            ext.setCy((long)height);
            CTPresetGeometry2D prstGeom = spPr.addNewPrstGeom();
            prstGeom.setPrst(STShapeType.RECT);
            prstGeom.addNewAvLst();
            XWPFPicture xwpfPicture = new XWPFPicture(pic, this.run);
            this.run.getEmbeddedPictures().add(xwpfPicture);
            return xwpfPicture;
        }
        catch (XmlException | SAXException e) {
            throw new IllegalStateException(e);
        }
    }

    private List<org.openxmlformats.schemas.drawingml.x2006.picture.CTPicture> getCTPictures(XmlObject o) {
        XmlObject[] picts;
        ArrayList<org.openxmlformats.schemas.drawingml.x2006.picture.CTPicture> pics = new ArrayList<org.openxmlformats.schemas.drawingml.x2006.picture.CTPicture>();
        for (XmlObject pict : picts = o.selectPath("declare namespace pic='" + org.openxmlformats.schemas.drawingml.x2006.picture.CTPicture.type.getName().getNamespaceURI() + "' .//pic:pic")) {
            if (pict instanceof XmlAnyTypeImpl) {
                try {
                    pict = CTPicture.Factory.parse((String)pict.toString(), (XmlOptions)POIXMLTypeLoader.DEFAULT_XML_OPTIONS);
                }
                catch (XmlException e) {
                    throw new POIXMLException((Throwable)e);
                }
            }
            if (!(pict instanceof org.openxmlformats.schemas.drawingml.x2006.picture.CTPicture)) continue;
            pics.add((org.openxmlformats.schemas.drawingml.x2006.picture.CTPicture)pict);
        }
        return pics;
    }
}

