/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.xwpf;

import com.deepoove.poi.util.ReflectionUtils;
import com.deepoove.poi.xwpf.BodyContainer;
import com.deepoove.poi.xwpf.XWPFSection;
import com.deepoove.poi.xwpf.XWPFStructuredDocumentTagContent;
import java.util.List;
import org.apache.poi.xwpf.usermodel.BodyElementType;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.ISDTContents;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtContentBlock;

public class SDTBodyContainer
implements BodyContainer {
    private XWPFStructuredDocumentTagContent sdtContent;

    public SDTBodyContainer(XWPFStructuredDocumentTagContent hf) {
        this.sdtContent = hf;
    }

    @Override
    public List<IBodyElement> getBodyElements() {
        return this.sdtContent.getBodyElements();
    }

    @Override
    public void removeBodyElement(int pos) {
        List<IBodyElement> bodyElements = this.getBodyElements();
        if (pos >= 0 && pos < bodyElements.size()) {
            BodyElementType type = bodyElements.get(pos).getElementType();
            if (type == BodyElementType.TABLE) {
                // empty if block
            }
            if (type == BodyElementType.PARAGRAPH) {
                this.sdtContent.removeParagraph((XWPFParagraph)bodyElements.get(pos));
            }
        }
    }

    @Override
    public void updateBodyElements(IBodyElement bodyElement, IBodyElement copy) {
        int pos = -1;
        List<ISDTContents> bodyElements = this.sdtContent.getSdtElements();
        for (int i = 0; i < bodyElements.size(); ++i) {
            if (bodyElements.get(i) != bodyElement) continue;
            pos = i;
        }
        if (-1 != pos) {
            bodyElements.set(pos, (ISDTContents)copy);
        }
    }

    @Override
    public void setParagraph(XWPFParagraph paragraph, int pos) {
        List paragraphs = (List)ReflectionUtils.getValue("paragraphs", this.sdtContent);
        paragraphs.set(pos, paragraph);
        CTSdtContentBlock sdtContentBlock = this.sdtContent.getSdtContentBlock();
        sdtContentBlock.setPArray(pos, paragraph.getCTP());
    }

    @Override
    public IBody getTarget() {
        return this.sdtContent;
    }

    @Override
    public void setTable(int pos, XWPFTable table) {
        throw new UnsupportedOperationException();
    }

    @Override
    public XWPFTable insertNewTable(XWPFRun run, int row, int col) {
        throw new UnsupportedOperationException();
    }

    @Override
    public XWPFSection closelySectPr(IBodyElement element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int elementPageWidth(IBodyElement element) {
        return 8295;
    }
}

