/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MergeCellRule
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<GridRule> mapping = new ArrayList<GridRule>();

    private MergeCellRule() {
    }

    public static MergeCellRuleBuilder builder() {
        return new MergeCellRuleBuilder();
    }

    public Iterator<Map.Entry<Grid, Grid>> mappingIterator() {
        LinkedHashMap ret = new LinkedHashMap();
        this.mapping.forEach(r -> ret.put(r.getFrom(), r.getTo()));
        return ret.entrySet().iterator();
    }

    public List<GridRule> getMapping() {
        return this.mapping;
    }

    public static final class MergeCellRuleBuilder {
        private Map<Grid, Grid> map = new LinkedHashMap<Grid, Grid>();

        private MergeCellRuleBuilder() {
        }

        public MergeCellRuleBuilder map(Grid from, Grid to) {
            if (from.equals(to)) {
                throw new IllegalArgumentException("The merged grid of from and to cannot be same!");
            }
            for (Map.Entry<Grid, Grid> next : this.map.entrySet()) {
                Grid value;
                Grid key = next.getKey();
                if (!from.inside(key, value = next.getValue()) && !to.inside(key, value)) continue;
                throw new IllegalArgumentException("The grid to be merged overlap! from " + from + " to " + to + " conflict with " + key + " to " + value);
            }
            this.map.put(from, to);
            return this;
        }

        public MergeCellRule build() {
            MergeCellRule mergeCellRule = new MergeCellRule();
            ArrayList mapping = new ArrayList();
            this.map.forEach((f, t) -> mapping.add(new GridRule((Grid)f, (Grid)t)));
            mergeCellRule.mapping = mapping;
            return mergeCellRule;
        }
    }

    public static class GridRule
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Grid from;
        private Grid to;

        public GridRule() {
        }

        public GridRule(Grid f, Grid t) {
            this.from = f;
            this.to = t;
        }

        public Grid getFrom() {
            return this.from;
        }

        public void setFrom(Grid from) {
            this.from = from;
        }

        public Grid getTo() {
            return this.to;
        }

        public void setTo(Grid to) {
            this.to = to;
        }
    }

    public static class Grid
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int i;
        private int j;

        private Grid() {
        }

        public static Grid of(int i, int j) {
            Grid grid = new Grid();
            grid.i = i;
            grid.j = j;
            return grid;
        }

        public boolean inside(Grid key, Grid value) {
            return this.isBetween(this.i, key.i, value.i) && this.isBetween(this.j, key.j, value.j);
        }

        private boolean isBetween(int row, int i, int j) {
            if (row == i) {
                return true;
            }
            if (row == j) {
                return true;
            }
            if (row > i && row < j) {
                return true;
            }
            return row > j && row < i;
        }

        public String toString() {
            return this.i + "-" + this.j;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.i;
            result = 31 * result + this.j;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Grid other = (Grid)obj;
            if (this.i != other.i) {
                return false;
            }
            return this.j == other.j;
        }

        public int getI() {
            return this.i;
        }

        public void setI(int i) {
            this.i = i;
        }

        public int getJ() {
            return this.j;
        }

        public void setJ(int j) {
            this.j = j;
        }
    }
}

