/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.plugin.comment;

import com.deepoove.poi.data.Paragraphs;
import com.deepoove.poi.exception.RenderException;
import com.deepoove.poi.plugin.comment.CommentContent;
import com.deepoove.poi.plugin.comment.CommentRenderData;
import com.deepoove.poi.plugin.comment.XWPFComment;
import com.deepoove.poi.plugin.comment.XWPFComments;
import com.deepoove.poi.policy.AbstractRenderPolicy;
import com.deepoove.poi.policy.DocumentRenderPolicy;
import com.deepoove.poi.policy.ParagraphRenderPolicy;
import com.deepoove.poi.render.RenderContext;
import com.deepoove.poi.util.ParagraphUtils;
import com.deepoove.poi.xwpf.NiceXWPFDocument;
import com.deepoove.poi.xwpf.XWPFParagraphWrapper;
import java.math.BigInteger;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;

public class CommentRenderPolicy
extends AbstractRenderPolicy<CommentRenderData> {
    @Override
    protected boolean validate(CommentRenderData data) {
        if (null == data) {
            return false;
        }
        if (null == data.getContents()) {
            throw new RenderException("CommentRenderData must set content!");
        }
        return true;
    }

    @Override
    public void doRender(RenderContext<CommentRenderData> context) throws Exception {
        Helper.renderComment(context.getRun(), context.getData());
    }

    @Override
    protected void afterRender(RenderContext<CommentRenderData> context) {
        this.clearPlaceholder(context, false);
    }

    public static class Helper {
        public static void renderComment(XWPFRun run, CommentRenderData data) throws Exception {
            XWPFParagraph paragraph = (XWPFParagraph)run.getParent();
            XWPFParagraphWrapper parentContext = new XWPFParagraphWrapper(paragraph);
            BigInteger cId = BigInteger.ZERO;
            CommentContent commentContent = data.getCommentContent();
            if (null != commentContent) {
                XWPFComments comments = ((NiceXWPFDocument)paragraph.getDocument()).createComments();
                XWPFComment newComment = comments.addComment();
                newComment.setAuthor(commentContent.getAuthor());
                newComment.setDate(commentContent.getDate());
                newComment.setInitials(commentContent.getInitials());
                DocumentRenderPolicy.Helper.renderDocument(newComment.createParagraph().createRun(), commentContent.getContent());
                cId = newComment.getCtComment().getId();
                parentContext.insertNewCommentRangeStart(run, cId);
            }
            ParagraphRenderPolicy.Helper.renderParagraph(run, Paragraphs.of().addList(data.getContents()).create());
            if (null != commentContent) {
                parentContext.insertNewCommentRangeEnd(run, cId);
                XWPFRun newRun = parentContext.insertNewRun(ParagraphUtils.getRunPos(run));
                newRun.getCTR().addNewCommentReference().setId(cId);
            }
        }
    }
}

