/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.render.processor;

import com.deepoove.poi.render.compute.EnvModel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;

public class EnvIterator {
    public static void foreach(Iterator<?> iterator, Consumer<EnvModel> consumer) {
        int index = 0;
        boolean hasNext = iterator.hasNext();
        while (hasNext) {
            Object root = iterator.next();
            hasNext = iterator.hasNext();
            consumer.accept(EnvModel.of(root, EnvIterator.makeEnv(index++, hasNext)));
        }
    }

    public static Map<String, Object> makeEnv(int index, boolean hasNext) {
        HashMap<String, Object> env = new HashMap<String, Object>();
        env.put("_is_first", index == 0);
        env.put("_is_last", !hasNext);
        env.put("_has_next", hasNext);
        env.put("_is_even_item", index % 2 == 1);
        env.put("_is_odd_item", index % 2 == 0);
        env.put("_index", index);
        return env;
    }
}

