/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.xwpf;

import com.deepoove.poi.xwpf.XWPFStructuredDocumentTagContent;
import java.util.List;
import org.apache.poi.ooxml.POIXMLDocumentPart;
import org.apache.poi.xwpf.usermodel.BodyElementType;
import org.apache.poi.xwpf.usermodel.BodyType;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.ICell;
import org.apache.poi.xwpf.usermodel.IRunElement;
import org.apache.poi.xwpf.usermodel.ISDTContents;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDataBinding;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtBlock;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtCell;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtRun;

public class XWPFStructuredDocumentTag
implements IBodyElement,
IRunElement,
ICell,
ISDTContents {
    private CTSdtRun ctSdtRun;
    private CTSdtBlock ctSdtBlock;
    private CTSdtCell ctSdtCell;
    private CTSdtPr ctSdtPr;
    private final IBody part;
    private final XWPFStructuredDocumentTagContent content;

    public XWPFStructuredDocumentTag(CTSdtRun sdtRun, IBody part) {
        this.ctSdtRun = sdtRun;
        this.part = part;
        this.ctSdtPr = sdtRun.getSdtPr();
        this.content = new XWPFStructuredDocumentTagContent(sdtRun.getSdtContent(), part, this);
    }

    public XWPFStructuredDocumentTag(CTSdtBlock block, IBody part) {
        this.ctSdtBlock = block;
        this.part = part;
        this.ctSdtPr = block.getSdtPr();
        this.content = new XWPFStructuredDocumentTagContent(block.getSdtContent(), part, this);
    }

    public XWPFStructuredDocumentTag(CTSdtCell sdtCell, XWPFTableRow xwpfTableRow, IBody part) {
        this.ctSdtCell = sdtCell;
        this.part = part;
        this.ctSdtPr = sdtCell.getSdtPr();
        this.content = new XWPFStructuredDocumentTagContent(sdtCell.getSdtContent(), xwpfTableRow, part, this);
    }

    public CTSdtRun getCtSdtRun() {
        return this.ctSdtRun;
    }

    public CTSdtBlock getCtSdtBlock() {
        return this.ctSdtBlock;
    }

    public CTSdtCell getCtSdtCell() {
        return this.ctSdtCell;
    }

    public XWPFStructuredDocumentTagContent getContent() {
        return this.content;
    }

    public CTDataBinding getDataBinding() {
        List dataBindingList = this.ctSdtPr.getDataBindingList();
        if (null == dataBindingList || dataBindingList.isEmpty()) {
            return null;
        }
        return (CTDataBinding)dataBindingList.get(0);
    }

    public POIXMLDocumentPart getPart() {
        return this.part.getPart();
    }

    public BodyType getPartType() {
        return BodyType.CONTENTCONTROL;
    }

    public BodyElementType getElementType() {
        return BodyElementType.CONTENTCONTROL;
    }

    public XWPFDocument getDocument() {
        return this.part.getXWPFDocument();
    }

    public IBody getBody() {
        return this.part;
    }
}

