/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.policy;

import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.config.Configure;
import com.deepoove.poi.data.DocxRenderData;
import com.deepoove.poi.exception.RenderException;
import com.deepoove.poi.policy.AbstractRenderPolicy;
import com.deepoove.poi.render.RenderContext;
import com.deepoove.poi.xwpf.NiceXWPFDocument;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.collections4.CollectionUtils;

public class DocxRenderPolicy
extends AbstractRenderPolicy<DocxRenderData> {
    @Override
    protected boolean validate(DocxRenderData data) {
        return null != data && null != data.getMergedDoc();
    }

    @Override
    protected void beforeRender(RenderContext<DocxRenderData> context) {
        this.clearPlaceholder(context, false);
    }

    @Override
    public void doRender(RenderContext<DocxRenderData> context) throws Exception {
        NiceXWPFDocument doc = context.getXWPFDocument();
        XWPFTemplate template = context.getTemplate();
        doc = doc.merge(new XWPFDocumentIterator(context.getData(), context.getConfig()), context.getRun());
        template.reload(doc);
    }

    class XWPFDocumentIterator
    implements Iterator<NiceXWPFDocument> {
        private Configure config;
        private byte[] bytes;
        private List<?> datas;
        private int length;
        int cursor = 0;

        XWPFDocumentIterator(DocxRenderData data, Configure config) {
            this.bytes = data.getMergedDoc();
            this.datas = data.getDataModels();
            this.config = config;
            this.length = null == this.datas ? 1 : this.datas.size();
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.length;
        }

        @Override
        public NiceXWPFDocument next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No instance of NiceXWPFDocument");
            }
            if (CollectionUtils.isEmpty(this.datas) && 0 == this.cursor) {
                try {
                    ++this.cursor;
                    return new NiceXWPFDocument(new ByteArrayInputStream(this.bytes));
                }
                catch (IOException e) {
                    throw new RenderException("Create XWPFDocument error", e);
                }
            }
            XWPFTemplate temp = XWPFTemplate.compile(new ByteArrayInputStream(this.bytes), this.config);
            temp.render(this.datas.get(this.cursor++));
            return temp.getXWPFDocument();
        }
    }
}

