/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.render.processor;

import com.deepoove.poi.render.processor.Visitor;
import com.deepoove.poi.template.ChartTemplate;
import com.deepoove.poi.template.InlineIterableTemplate;
import com.deepoove.poi.template.IterableTemplate;
import com.deepoove.poi.template.MetaTemplate;
import com.deepoove.poi.template.PictImageTemplate;
import com.deepoove.poi.template.PictureTemplate;
import com.deepoove.poi.template.run.RunTemplate;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogProcessor
implements Visitor {
    private static Logger log = LoggerFactory.getLogger(LogProcessor.class);
    private String indentState;

    public LogProcessor() {
        this.indentState = "";
    }

    public LogProcessor(String indent) {
        this.indentState = indent;
    }

    public void process(List<MetaTemplate> templates) {
        templates.forEach(template -> template.accept(this));
    }

    @Override
    public void visit(InlineIterableTemplate iterableTemplate) {
        this.visit((IterableTemplate)iterableTemplate);
    }

    @Override
    public void visit(RunTemplate runTemplate) {
        log.info("{}{}", (Object)this.indentState, (Object)runTemplate);
    }

    @Override
    public void visit(PictureTemplate pictureTemplate) {
        log.info("{}{}", (Object)this.indentState, (Object)pictureTemplate);
    }

    @Override
    public void visit(PictImageTemplate pictImageTemplate) {
        log.info("{}{}", (Object)this.indentState, (Object)pictImageTemplate);
    }

    @Override
    public void visit(IterableTemplate iterableTemplate) {
        log.info("{}{}", (Object)this.indentState, (Object)iterableTemplate.getStartMark());
        new LogProcessor(this.indentState + "  ").process(iterableTemplate.getTemplates());
        log.info("{}{}", (Object)this.indentState, (Object)iterableTemplate.getEndMark());
    }

    @Override
    public void visit(ChartTemplate chartTemplate) {
        log.info("{}{}", (Object)this.indentState, (Object)chartTemplate);
    }
}

