/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.xwpf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.poi.ooxml.POIXMLDocumentPart;
import org.apache.poi.util.Internal;
import org.apache.poi.xwpf.usermodel.BodyType;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTbl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTxbxContent;

public class XWPFTextboxContent
implements IBody {
    private final CTTxbxContent ctTxbxContent;
    protected List<XWPFParagraph> paragraphs;
    protected List<IBodyElement> bodyElements;
    protected IBody part;
    private XWPFRun run;
    private XmlObject xmlObject;

    public XWPFTextboxContent(CTTxbxContent ctTxbxContent, XWPFRun run, IBody part, XmlObject xmlObject) {
        this.ctTxbxContent = ctTxbxContent;
        this.part = part;
        this.run = run;
        this.xmlObject = xmlObject;
        this.bodyElements = new ArrayList<IBodyElement>();
        this.paragraphs = new ArrayList<XWPFParagraph>();
        XmlCursor cursor = ctTxbxContent.newCursor();
        cursor.selectPath("./*");
        while (cursor.toNextSelection()) {
            XmlObject o = cursor.getObject();
            if (!(o instanceof CTP)) continue;
            XWPFParagraph p = new XWPFParagraph((CTP)o, (IBody)this);
            this.paragraphs.add(p);
            this.bodyElements.add((IBodyElement)p);
        }
        cursor.dispose();
    }

    @Internal
    public CTTxbxContent getCTTxbxContent() {
        return this.ctTxbxContent;
    }

    @Internal
    public XmlObject getXmlObject() {
        return this.xmlObject;
    }

    public POIXMLDocumentPart getPart() {
        return this.run.getParagraph().getPart();
    }

    public BodyType getPartType() {
        return BodyType.TABLECELL;
    }

    public List<IBodyElement> getBodyElements() {
        return Collections.unmodifiableList(this.bodyElements);
    }

    public void setParagraph(XWPFParagraph p) {
        if (this.ctTxbxContent.sizeOfPArray() == 0) {
            this.ctTxbxContent.addNewP();
        }
        this.ctTxbxContent.setPArray(0, p.getCTP());
    }

    public List<XWPFParagraph> getParagraphs() {
        return Collections.unmodifiableList(this.paragraphs);
    }

    public XWPFParagraph addParagraph() {
        XWPFParagraph p = new XWPFParagraph(this.ctTxbxContent.addNewP(), (IBody)this);
        this.addParagraph(p);
        return p;
    }

    public void addParagraph(XWPFParagraph p) {
        this.paragraphs.add(p);
        this.bodyElements.add((IBodyElement)p);
    }

    public void removeParagraph(int pos) {
        XWPFParagraph removedParagraph = this.paragraphs.get(pos);
        this.paragraphs.remove(pos);
        this.ctTxbxContent.removeP(pos);
        this.bodyElements.remove(removedParagraph);
    }

    public void removeParagraph(XWPFParagraph paragraph) {
        if (this.paragraphs.contains(paragraph)) {
            CTP ctP = paragraph.getCTP();
            XmlCursor c = ctP.newCursor();
            c.removeXml();
            c.dispose();
            this.paragraphs.remove(paragraph);
            this.bodyElements.remove(paragraph);
        }
    }

    public XWPFParagraph getParagraph(CTP p) {
        for (XWPFParagraph paragraph : this.paragraphs) {
            if (!p.equals(paragraph.getCTP())) continue;
            return paragraph;
        }
        return null;
    }

    public XWPFParagraph insertNewParagraph(XmlCursor cursor) {
        if (!this.isCursorInTextBox(cursor)) {
            return null;
        }
        String uri = CTP.type.getName().getNamespaceURI();
        String localPart = "p";
        cursor.beginElement(localPart, uri);
        cursor.toParent();
        CTP p = (CTP)cursor.getObject();
        XWPFParagraph newP = new XWPFParagraph(p, (IBody)this);
        XmlObject o = null;
        while (!(o instanceof CTP) && cursor.toPrevSibling()) {
            o = cursor.getObject();
        }
        if (!(o instanceof CTP) || o == p) {
            this.paragraphs.add(0, newP);
        } else {
            int pos = this.paragraphs.indexOf(this.getParagraph((CTP)o)) + 1;
            this.paragraphs.add(pos, newP);
        }
        int i = 0;
        XmlCursor p2 = p.newCursor();
        cursor.toCursor(p2);
        p2.dispose();
        while (cursor.toPrevSibling()) {
            o = cursor.getObject();
            if (!(o instanceof CTP) && !(o instanceof CTTbl)) continue;
            ++i;
        }
        this.bodyElements.add(i, (IBodyElement)newP);
        p2 = p.newCursor();
        cursor.toCursor(p2);
        p2.dispose();
        cursor.toEndToken();
        return newP;
    }

    private boolean isCursorInTextBox(XmlCursor cursor) {
        XmlCursor verify = cursor.newCursor();
        verify.toParent();
        boolean result = verify.getObject() == this.ctTxbxContent;
        verify.dispose();
        return result;
    }

    public XWPFParagraph getParagraphArray(int pos) {
        if (pos >= 0 && pos < this.paragraphs.size()) {
            return this.paragraphs.get(pos);
        }
        return null;
    }

    public XWPFTable getTable(CTTbl ctTable) {
        return null;
    }

    public XWPFTable getTableArray(int pos) {
        return null;
    }

    public List<XWPFTable> getTables() {
        return null;
    }

    public void insertTable(int pos, XWPFTable table) {
        throw new UnsupportedOperationException();
    }

    public XWPFDocument getXWPFDocument() {
        return this.part.getXWPFDocument();
    }

    public XWPFTable insertNewTbl(XmlCursor cursor) {
        throw new UnsupportedOperationException();
    }

    public XWPFTableCell getTableCell(CTTc cell) {
        return null;
    }
}

