/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.data;

import com.deepoove.poi.data.DocumentRenderData;
import com.deepoove.poi.data.NumberingRenderData;
import com.deepoove.poi.data.ParagraphRenderData;
import com.deepoove.poi.data.RenderDataBuilder;
import com.deepoove.poi.data.TableRenderData;

public class Documents {
    private Documents() {
    }

    public static DocumentBuilder of() {
        return new DocumentBuilder();
    }

    public static class DocumentBuilder
    implements RenderDataBuilder<DocumentRenderData> {
        private DocumentRenderData data = new DocumentRenderData();

        private DocumentBuilder() {
        }

        public DocumentBuilder addParagraph(ParagraphRenderData paragraph) {
            this.data.addParagraph(paragraph);
            return this;
        }

        public DocumentBuilder addNumbering(NumberingRenderData numbering) {
            this.data.addNumbering(numbering);
            return this;
        }

        public DocumentBuilder addTable(TableRenderData table) {
            this.data.addTable(table);
            return this;
        }

        public DocumentBuilder addDocument(DocumentRenderData document) {
            this.data.getContents().addAll(document.getContents());
            return this;
        }

        @Override
        public DocumentRenderData create() {
            return this.data;
        }
    }
}

