/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.data;

import com.deepoove.poi.xwpf.NumFormat;
import java.io.Serializable;
import java.text.MessageFormat;

public class NumberingFormat
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final NumberingFormat BULLET = new NumberingFormat(NumFormat.BULLET, "\u25cf");
    public static final NumberingFormat DECIMAL;
    public static final NumberingFormat DECIMAL_PARENTHESES;
    public static final NumberingFormat LOWER_LETTER;
    public static final NumberingFormat LOWER_ROMAN;
    public static final NumberingFormat UPPER_LETTER;
    public static final NumberingFormat UPPER_ROMAN;
    public static final Builder DECIMAL_BUILDER;
    public static final Builder DECIMAL_PARENTHESES_BUILDER;
    public static final Builder LOWER_LETTER_BUILDER;
    public static final Builder LOWER_ROMAN_BUILDER;
    public static final Builder UPPER_LETTER_BUILDER;
    public static final Builder UPPER_ROMAN_BUILDER;
    private int numFmt;
    private String lvlText;

    public NumberingFormat(NumFormat numFmt, String lvlText) {
        this.numFmt = numFmt.getValue();
        this.lvlText = lvlText;
    }

    public NumberingFormat(int numFmt, String lvlText) {
        this.numFmt = numFmt;
        this.lvlText = lvlText;
    }

    public int getNumFmt() {
        return this.numFmt;
    }

    public String getLvlText() {
        return this.lvlText;
    }

    public static Builder builder(String lvlTemplate) {
        return new Builder(lvlTemplate);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.lvlText == null ? 0 : this.lvlText.hashCode());
        result = 31 * result + this.numFmt;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NumberingFormat other = (NumberingFormat)obj;
        if (this.lvlText == null ? other.lvlText != null : !this.lvlText.equals(other.lvlText)) {
            return false;
        }
        return this.numFmt == other.numFmt;
    }

    public String toString() {
        return "NumberingFormat [numFmt=" + this.numFmt + ", lvlText=" + this.lvlText + "]";
    }

    static {
        DECIMAL_BUILDER = NumberingFormat.builder("%{0}.").withNumFmt(NumFormat.DECIMAL);
        DECIMAL_PARENTHESES_BUILDER = NumberingFormat.builder("%{0})").withNumFmt(NumFormat.DECIMAL);
        LOWER_LETTER_BUILDER = NumberingFormat.builder("%{0}.").withNumFmt(NumFormat.LOWER_LETTER);
        LOWER_ROMAN_BUILDER = NumberingFormat.builder("%{0}.").withNumFmt(NumFormat.LOWER_ROMAN);
        UPPER_LETTER_BUILDER = NumberingFormat.builder("%{0}.").withNumFmt(NumFormat.UPPER_LETTER);
        UPPER_ROMAN_BUILDER = NumberingFormat.builder("%{0}.").withNumFmt(NumFormat.UPPER_ROMAN);
        DECIMAL = DECIMAL_BUILDER.build(0);
        DECIMAL_PARENTHESES = DECIMAL_PARENTHESES_BUILDER.build(0);
        LOWER_LETTER = LOWER_LETTER_BUILDER.build(0);
        LOWER_ROMAN = LOWER_ROMAN_BUILDER.build(0);
        UPPER_LETTER = UPPER_LETTER_BUILDER.build(0);
        UPPER_ROMAN = UPPER_ROMAN_BUILDER.build(0);
    }

    public static final class Builder {
        private NumFormat numFmt;
        private String lvlTemplate;

        private Builder(String lvlTemplate) {
            this.lvlTemplate = lvlTemplate;
        }

        public Builder withNumFmt(NumFormat numFmt) {
            this.numFmt = numFmt;
            return this;
        }

        public NumberingFormat build(int level) {
            return new NumberingFormat(this.numFmt, MessageFormat.format(this.lvlTemplate, ++level));
        }
    }
}

