/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.data;

import com.deepoove.poi.data.NumberingFormat;
import com.deepoove.poi.data.NumberingItemRenderData;
import com.deepoove.poi.data.NumberingRenderData;
import com.deepoove.poi.data.ParagraphRenderData;
import com.deepoove.poi.data.Paragraphs;
import com.deepoove.poi.data.PictureRenderData;
import com.deepoove.poi.data.RenderDataBuilder;
import com.deepoove.poi.data.TextRenderData;
import com.deepoove.poi.data.Texts;
import java.util.ArrayList;
import java.util.Arrays;

public class Numberings {
    private Numberings() {
    }

    public static NumberingBuilder ofBullet() {
        return Numberings.of(NumberingFormat.BULLET);
    }

    public static NumberingBuilder ofBullet(String ... text) {
        NumberingBuilder inst = Numberings.of(NumberingFormat.BULLET);
        if (null != text) {
            Arrays.stream(text).forEach(inst::addItem);
        }
        return inst;
    }

    public static NumberingBuilder ofDecimal() {
        return Numberings.of(NumberingFormat.DECIMAL);
    }

    public static NumberingBuilder ofDecimal(String ... text) {
        NumberingBuilder inst = Numberings.of(NumberingFormat.DECIMAL);
        if (null != text) {
            Arrays.stream(text).forEach(inst::addItem);
        }
        return inst;
    }

    public static NumberingBuilder ofDecimalParentheses() {
        return Numberings.of(NumberingFormat.DECIMAL_PARENTHESES);
    }

    public static NumberingBuilder ofDecimalParentheses(String ... text) {
        NumberingBuilder inst = Numberings.of(NumberingFormat.DECIMAL_PARENTHESES);
        if (null != text) {
            Arrays.stream(text).forEach(inst::addItem);
        }
        return inst;
    }

    public static NumberingBuilder ofLowerLetter() {
        return Numberings.of(NumberingFormat.LOWER_LETTER);
    }

    public static NumberingBuilder ofLowerLetter(String ... text) {
        NumberingBuilder inst = Numberings.of(NumberingFormat.LOWER_LETTER);
        if (null != text) {
            Arrays.stream(text).forEach(inst::addItem);
        }
        return inst;
    }

    public static NumberingBuilder ofLowerRoman() {
        return Numberings.of(NumberingFormat.LOWER_ROMAN);
    }

    public static NumberingBuilder ofLowerRoman(String ... text) {
        NumberingBuilder inst = Numberings.of(NumberingFormat.LOWER_ROMAN);
        if (null != text) {
            Arrays.stream(text).forEach(inst::addItem);
        }
        return inst;
    }

    public static NumberingBuilder ofUpperLetter() {
        return Numberings.of(NumberingFormat.UPPER_LETTER);
    }

    public static NumberingBuilder ofUpperLetter(String ... text) {
        NumberingBuilder inst = Numberings.of(NumberingFormat.UPPER_LETTER);
        if (null != text) {
            Arrays.stream(text).forEach(inst::addItem);
        }
        return inst;
    }

    public static NumberingBuilder ofUpperRoman() {
        return Numberings.of(NumberingFormat.UPPER_ROMAN);
    }

    public static NumberingBuilder ofUpperRoman(String ... text) {
        NumberingBuilder inst = Numberings.of(NumberingFormat.UPPER_ROMAN);
        if (null != text) {
            Arrays.stream(text).forEach(inst::addItem);
        }
        return inst;
    }

    public static NumberingBuilder of(NumberingFormat format) {
        return new NumberingBuilder(format);
    }

    public static NumberingBuilder of(TextRenderData ... text) {
        NumberingBuilder inst = Numberings.ofBullet();
        if (null != text) {
            Arrays.stream(text).forEach(inst::addItem);
        }
        return inst;
    }

    public static NumberingBuilder of(String ... text) {
        NumberingBuilder inst = Numberings.ofBullet();
        if (null != text) {
            Arrays.stream(text).forEach(inst::addItem);
        }
        return inst;
    }

    public static NumberingRenderData create(String ... text) {
        return Numberings.of(text).create();
    }

    public static class NumberingBuilder
    implements RenderDataBuilder<NumberingRenderData> {
        private NumberingRenderData data;

        private NumberingBuilder(NumberingFormat format) {
            this.data = new NumberingRenderData(format, new ArrayList<ParagraphRenderData>());
        }

        public NumberingBuilder addItem(ParagraphRenderData item) {
            this.data.getItems().add(new NumberingItemRenderData(0, item));
            return this;
        }

        public NumberingBuilder addItem(TextRenderData item) {
            this.data.getItems().add(new NumberingItemRenderData(0, Paragraphs.of(item).create()));
            return this;
        }

        public NumberingBuilder addItem(PictureRenderData item) {
            this.data.getItems().add(new NumberingItemRenderData(0, Paragraphs.of(item).create()));
            return this;
        }

        public NumberingBuilder addItem(String text) {
            this.addItem(Texts.of(text).create());
            return this;
        }

        @Override
        public NumberingRenderData create() {
            return this.data;
        }
    }
}

