/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.xwpf;

import com.deepoove.poi.util.ReflectionUtils;
import com.deepoove.poi.xwpf.BodyContainer;
import com.deepoove.poi.xwpf.XWPFSection;
import com.deepoove.poi.xwpf.XWPFTextboxContent;
import java.util.List;
import org.apache.poi.xwpf.usermodel.BodyElementType;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTxbxContent;

public class TextBoxBodyContainer
implements BodyContainer {
    private XWPFTextboxContent textbox;

    public TextBoxBodyContainer(XWPFTextboxContent textbox) {
        this.textbox = textbox;
    }

    @Override
    public void removeBodyElement(int pos) {
        List<IBodyElement> bodyElements = this.getBodyElements();
        if (pos >= 0 && pos < bodyElements.size()) {
            BodyElementType type = bodyElements.get(pos).getElementType();
            if (type == BodyElementType.TABLE) {
                // empty if block
            }
            if (type == BodyElementType.PARAGRAPH) {
                this.textbox.removeParagraph((XWPFParagraph)bodyElements.get(pos));
            }
        }
    }

    @Override
    public void setParagraph(XWPFParagraph paragraph, int pos) {
        List paragraphs = (List)ReflectionUtils.getValue("paragraphs", this.textbox);
        paragraphs.set(pos, paragraph);
        CTTxbxContent ctTxbxContent = this.textbox.getCTTxbxContent();
        ctTxbxContent.setPArray(pos, paragraph.getCTP());
    }

    @Override
    public IBody getTarget() {
        return this.textbox;
    }

    @Override
    public void setTable(int pos, XWPFTable table) {
        throw new UnsupportedOperationException();
    }

    @Override
    public XWPFTable insertNewTable(XWPFRun run, int row, int col) {
        throw new UnsupportedOperationException();
    }

    @Override
    public XWPFSection closelySectPr(IBodyElement element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int elementPageWidth(IBodyElement element) {
        return 8295;
    }
}

