/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.data;

import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.data.AttachmentRenderData;
import com.deepoove.poi.data.AttachmentType;
import com.deepoove.poi.data.ByteArrayAttachmentRenderData;
import com.deepoove.poi.data.FileAttachmentRenderData;
import com.deepoove.poi.data.RenderDataBuilder;
import com.deepoove.poi.data.UrlAttachmentRenderData;
import com.deepoove.poi.exception.ResolverException;
import com.deepoove.poi.util.ByteUtils;
import com.deepoove.poi.util.PoitlIOUtils;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.ooxml.POIXMLDocument;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xwpf.usermodel.XWPFDocument;

public class Attachments {
    private Attachments() {
    }

    public static AttachmentBuilder of(String src) {
        if (src.startsWith("http")) {
            return Attachments.ofUrl(src);
        }
        return Attachments.ofLocal(src);
    }

    public static AttachmentBuilder ofLocal(String path) {
        return Attachments.ofLocal(path, null);
    }

    public static AttachmentBuilder ofLocal(String path, AttachmentType fileType) {
        return new AttachmentBuilder(new FileAttachmentRenderData(path, fileType));
    }

    public static AttachmentBuilder ofUrl(String url) {
        return Attachments.ofUrl(url, null);
    }

    public static AttachmentBuilder ofUrl(String url, AttachmentType fileType) {
        return new AttachmentBuilder(new UrlAttachmentRenderData(url, fileType));
    }

    public static AttachmentBuilder ofWord(XWPFDocument src) {
        try {
            return Attachments.ofStream(PoitlIOUtils.docToInputStream((POIXMLDocument)src), AttachmentType.DOCX);
        }
        catch (IOException e) {
            throw new ResolverException("Cannot compile attachment document", e);
        }
    }

    public static AttachmentBuilder ofWordTemplate(XWPFTemplate src) {
        try {
            return Attachments.ofStream(PoitlIOUtils.templateToInputStream(src), AttachmentType.DOCX);
        }
        catch (IOException e) {
            throw new ResolverException("Cannot compile attachment document", e);
        }
    }

    public static AttachmentBuilder ofWorkbook(XSSFWorkbook src) {
        try {
            return Attachments.ofStream(PoitlIOUtils.docToInputStream((POIXMLDocument)src), AttachmentType.XLSX);
        }
        catch (IOException e) {
            throw new ResolverException("Cannot compile attachment document", e);
        }
    }

    public static AttachmentBuilder ofStream(InputStream inputStream, AttachmentType fileType) {
        return Attachments.ofBytes(ByteUtils.toByteArray(inputStream), fileType);
    }

    public static AttachmentBuilder ofStream(InputStream inputStream) {
        return Attachments.ofBytes(ByteUtils.toByteArray(inputStream));
    }

    public static AttachmentBuilder ofBytes(byte[] bytes, AttachmentType fileType) {
        return new AttachmentBuilder(new ByteArrayAttachmentRenderData(bytes, fileType));
    }

    public static AttachmentBuilder ofBytes(byte[] bytes) {
        return Attachments.ofBytes(bytes, null);
    }

    public static class AttachmentBuilder
    implements RenderDataBuilder<AttachmentRenderData> {
        AttachmentRenderData data;

        private AttachmentBuilder(AttachmentRenderData data) {
            this.data = data;
        }

        @Override
        public AttachmentRenderData create() {
            return this.data;
        }
    }
}

