/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.data;

import com.deepoove.poi.data.DocxRenderData;
import com.deepoove.poi.data.RenderDataBuilder;
import com.deepoove.poi.util.ByteUtils;
import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;

public class Includes {
    private Includes() {
    }

    public static IncludeBuilder ofLocal(String src) {
        return Includes.ofBytes(ByteUtils.getLocalByteArray(new File(src)));
    }

    public static IncludeBuilder ofStream(InputStream inputStream) {
        return Includes.ofBytes(ByteUtils.toByteArray(inputStream));
    }

    public static IncludeBuilder ofBytes(byte[] bytes) {
        return new IncludeBuilder(bytes);
    }

    public static class IncludeBuilder
    implements RenderDataBuilder<DocxRenderData> {
        DocxRenderData data;

        private IncludeBuilder(byte[] bytes) {
            this.data = new DocxRenderData(bytes, null);
        }

        public IncludeBuilder setRenderModel(List<?> models) {
            this.data.setDataModels(models);
            return this;
        }

        public IncludeBuilder setRenderModel(Object model) {
            return this.setRenderModel(Arrays.asList(model));
        }

        @Override
        public DocxRenderData create() {
            return this.data;
        }
    }
}

