/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.plugin.comment;

import com.deepoove.poi.data.DocumentRenderData;
import com.deepoove.poi.data.Documents;
import com.deepoove.poi.data.Paragraphs;
import com.deepoove.poi.data.PictureRenderData;
import com.deepoove.poi.data.RenderDataBuilder;
import com.deepoove.poi.data.TextRenderData;
import com.deepoove.poi.data.Texts;
import com.deepoove.poi.plugin.comment.CommentContent;
import com.deepoove.poi.plugin.comment.CommentRenderData;
import java.util.Calendar;

public final class Comments {
    private Comments() {
    }

    public static CommentBuilder of() {
        return new CommentBuilder();
    }

    public static CommentBuilder of(TextRenderData text) {
        CommentBuilder builder = new CommentBuilder();
        builder.addText(text);
        return builder;
    }

    public static CommentBuilder of(String text) {
        CommentBuilder builder = new CommentBuilder();
        builder.addText(text);
        return builder;
    }

    public static class CommentBuilder
    implements RenderDataBuilder<CommentRenderData> {
        private CommentRenderData data = new CommentRenderData();

        private CommentBuilder() {
        }

        public CommentBuilder signature(String author, String initials, Calendar date) {
            CommentContent comment = this.getCommentContent();
            comment.setAuthor(author);
            comment.setInitials(initials);
            comment.setDate(date);
            return this;
        }

        public CommentBuilder comment(DocumentRenderData content) {
            CommentContent comment = this.getCommentContent();
            comment.setContent(content);
            return this;
        }

        public CommentBuilder comment(String text) {
            return this.comment(Documents.of().addParagraph(Paragraphs.of(text).create()).create());
        }

        public CommentBuilder addText(TextRenderData text) {
            this.data.getContents().add(text);
            return this;
        }

        public CommentBuilder addText(String text) {
            this.data.getContents().add(Texts.of(text).create());
            return this;
        }

        public CommentBuilder addPicture(PictureRenderData picture) {
            this.data.getContents().add(picture);
            return this;
        }

        public CommentBuilder addSubComment(CommentRenderData subcomment) {
            this.data.getContents().add(subcomment);
            return this;
        }

        private CommentContent getCommentContent() {
            CommentContent comment = this.data.getCommentContent();
            if (null == comment) {
                comment = new CommentContent();
                this.data.setCommentContent(comment);
            }
            return comment;
        }

        @Override
        public CommentRenderData create() {
            return this.data;
        }
    }
}

