/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.render.processor;

import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.render.compute.RenderDataCompute;
import com.deepoove.poi.render.processor.DefaultTemplateProcessor;
import com.deepoove.poi.render.processor.DocumentProcessor;
import com.deepoove.poi.render.processor.Iteration;
import com.deepoove.poi.resolver.Resolver;
import com.deepoove.poi.template.IterableTemplate;
import com.deepoove.poi.template.MetaTemplate;
import com.deepoove.poi.xwpf.BodyContainer;
import com.deepoove.poi.xwpf.BodyContainerFactory;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIterableProcessor
extends DefaultTemplateProcessor
implements Iteration {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    public AbstractIterableProcessor(XWPFTemplate template, Resolver resolver, RenderDataCompute renderDataCompute) {
        super(template, resolver, renderDataCompute);
    }

    @Override
    public void visit(IterableTemplate iterableTemplate) {
        BodyContainer bodyContainer = BodyContainerFactory.getBodyContainer(iterableTemplate);
        Object compute = this.renderDataCompute.compute(iterableTemplate.getStartMark().getTagName());
        if (null == compute || compute instanceof Boolean && !((Boolean)compute).booleanValue()) {
            this.handleNever(iterableTemplate, bodyContainer);
            this.afterHandle(iterableTemplate, bodyContainer, true);
        } else if (compute instanceof Iterable) {
            this.handleIterable(iterableTemplate, bodyContainer, (Iterable)compute);
            this.afterHandle(iterableTemplate, bodyContainer, false);
        } else {
            if (compute instanceof Boolean && ((Boolean)compute).booleanValue()) {
                this.handleOnceWithScope(iterableTemplate, this.renderDataCompute);
            } else {
                this.handleOnce(iterableTemplate, compute);
            }
            this.afterHandle(iterableTemplate, bodyContainer, false);
        }
    }

    protected void afterHandle(IterableTemplate iterableTemplate, BodyContainer bodyContainer, boolean remove) {
        bodyContainer.clearPlaceholder(iterableTemplate.getStartRun(), remove);
        bodyContainer.clearPlaceholder(iterableTemplate.getEndRun(), remove);
    }

    protected abstract void handleNever(IterableTemplate var1, BodyContainer var2);

    protected abstract void handleIterable(IterableTemplate var1, BodyContainer var2, Iterable<?> var3);

    protected void handleOnce(IterableTemplate iterableTemplate, Object compute) {
        this.process(iterableTemplate.getTemplates(), compute);
    }

    protected void handleOnceWithScope(IterableTemplate iterableTemplate, RenderDataCompute dataCompute) {
        new DocumentProcessor(this.template, this.resolver, dataCompute).process(iterableTemplate.getTemplates());
    }

    protected void process(List<MetaTemplate> templates, Object model) {
        RenderDataCompute dataCompute = this.template.getConfig().getRenderDataComputeFactory().newCompute(model);
        new DocumentProcessor(this.template, this.resolver, dataCompute).process(templates);
    }
}

