/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.xwpf;

import com.deepoove.poi.data.NumberingFormat;
import com.deepoove.poi.util.ParagraphUtils;
import com.deepoove.poi.util.PoitlIOUtils;
import com.deepoove.poi.util.ReflectionUtils;
import com.deepoove.poi.util.UnitUtils;
import com.deepoove.poi.xwpf.BodyContainer;
import com.deepoove.poi.xwpf.BodyContainerFactory;
import com.deepoove.poi.xwpf.IdenifierManagerWrapper;
import com.deepoove.poi.xwpf.XWPFChartFactory;
import com.deepoove.poi.xwpf.XWPFNumberingWrapper;
import com.deepoove.poi.xwpf.XWPFStructuredDocumentTag;
import com.deepoove.poi.xwpf.XmlXWPFDocumentMerge;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.ooxml.POIXMLDocumentPart;
import org.apache.poi.ooxml.POIXMLException;
import org.apache.poi.ooxml.POIXMLFactory;
import org.apache.poi.ooxml.POIXMLRelation;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackagePartName;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.openxml4j.opc.PackagingURIHelper;
import org.apache.poi.openxml4j.opc.TargetMode;
import org.apache.poi.xwpf.usermodel.BodyElementType;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.XWPFAbstractNum;
import org.apache.poi.xwpf.usermodel.XWPFChart;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFFactory;
import org.apache.poi.xwpf.usermodel.XWPFNumbering;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFPicture;
import org.apache.poi.xwpf.usermodel.XWPFRelation;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.CTAnchor;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.CTInline;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTAbstractNum;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBody;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDocument1;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDrawing;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFonts;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTInd;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTLvl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPPrGeneral;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTR;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtBlock;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTbl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STHint;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STJc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STNumberFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NiceXWPFDocument
extends XWPFDocument {
    private static Logger logger = LoggerFactory.getLogger(NiceXWPFDocument.class);
    protected List<XWPFStructuredDocumentTag> structuredDocumentTags = new ArrayList<XWPFStructuredDocumentTag>();
    protected List<XWPFTable> allTables = new ArrayList<XWPFTable>();
    protected List<XWPFPicture> allPictures = new ArrayList<XWPFPicture>();
    protected List<POIXMLDocumentPart> embedds = new ArrayList<POIXMLDocumentPart>();
    protected IdenifierManagerWrapper idenifierManagerWrapper;
    protected boolean adjustDoc = false;
    protected Map<XWPFChart, PackagePart> chartMappingPart = new HashMap<XWPFChart, PackagePart>();
    protected static XWPFRelation DOCUMENT;

    public NiceXWPFDocument() {
    }

    public NiceXWPFDocument(InputStream in) throws IOException {
        this(in, false);
    }

    public NiceXWPFDocument(InputStream in, boolean adjustDoc) throws IOException {
        super(in);
        this.adjustDoc = adjustDoc;
        this.idenifierManagerWrapper = new IdenifierManagerWrapper(this);
        this.niceDocumentRead();
    }

    protected void onDocumentCreate() {
        super.onDocumentCreate();
        try {
            CTDocument1 ctDocument = this.getDocument();
            CTDocument1 parse = null;
            String doc = "<xml-fragment xmlns:wpc=\"http://schemas.microsoft.com/office/word/2010/wordprocessingCanvas\" \n    xmlns:mo=\"http://schemas.microsoft.com/office/mac/office/2008/main\" \n    xmlns:mc=\"http://schemas.openxmlformats.org/markup-compatibility/2006\" \n    xmlns:mv=\"urn:schemas-microsoft-com:mac:vml\" \n    xmlns:o=\"urn:schemas-microsoft-com:office:office\" \n    xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" \n    xmlns:m=\"http://schemas.openxmlformats.org/officeDocument/2006/math\" \n    xmlns:v=\"urn:schemas-microsoft-com:vml\" \n    xmlns:wp14=\"http://schemas.microsoft.com/office/word/2010/wordprocessingDrawing\" \n    xmlns:wp=\"http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing\" \n    xmlns:w10=\"urn:schemas-microsoft-com:office:word\" \n    xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\" \n    xmlns:w14=\"http://schemas.microsoft.com/office/word/2010/wordml\" \n    xmlns:wpg=\"http://schemas.microsoft.com/office/word/2010/wordprocessingGroup\" \n    xmlns:wpi=\"http://schemas.microsoft.com/office/word/2010/wordprocessingInk\" \n    xmlns:wne=\"http://schemas.microsoft.com/office/word/2006/wordml\" \n    xmlns:wps=\"http://schemas.microsoft.com/office/word/2010/wordprocessingShape\" mc:Ignorable=\"w14 wp14\"><w:body></w:body></xml-fragment>";
            parse = (CTDocument1)CTDocument1.Factory.parse(doc);
            ctDocument.set((XmlObject)parse);
        }
        catch (XmlException e) {
            logger.warn("Create new document error: {}", (Object)e.getMessage());
        }
    }

    private void niceDocumentRead() throws IOException {
        this.read((IBody)this);
        this.getHeaderList().forEach(header -> this.read((IBody)header));
        this.getFooterList().forEach(header -> this.read((IBody)header));
        if (!this.contentControls.isEmpty()) {
            XmlCursor docCursor = this.getDocument().newCursor();
            docCursor.selectPath("./*");
            while (docCursor.toNextSelection()) {
                XmlObject o = docCursor.getObject();
                if (!(o instanceof CTBody)) continue;
                XmlCursor bodyCursor = o.newCursor();
                bodyCursor.selectPath("./*");
                while (bodyCursor.toNextSelection()) {
                    XmlObject bodyObj = bodyCursor.getObject();
                    if (!(bodyObj instanceof CTSdtBlock)) continue;
                    XWPFStructuredDocumentTag c = new XWPFStructuredDocumentTag((CTSdtBlock)bodyObj, (IBody)this);
                    this.bodyElements.add(c);
                    this.structuredDocumentTags.add(c);
                }
                bodyCursor.dispose();
            }
            docCursor.dispose();
        }
    }

    public List<XWPFPicture> getAllEmbeddedPictures() {
        return Collections.unmodifiableList(this.allPictures);
    }

    public List<XWPFTable> getAllTables() {
        return Collections.unmodifiableList(this.allTables);
    }

    public IdenifierManagerWrapper getDocPrIdenifierManager() {
        return this.idenifierManagerWrapper;
    }

    public BigInteger addNewNumberingId(NumberingFormat numFmt) {
        return this.addNewMultiLevelNumberingId(numFmt);
    }

    public BigInteger addNewMultiLevelNumberingId(NumberingFormat ... numFmts) {
        XWPFNumbering numbering = this.getNumbering();
        if (null == numbering) {
            numbering = this.createNumbering();
        }
        XWPFNumberingWrapper numberingWrapper = new XWPFNumberingWrapper(numbering);
        CTAbstractNum cTAbstractNum = (CTAbstractNum)CTAbstractNum.Factory.newInstance();
        cTAbstractNum.setAbstractNumId(numberingWrapper.getNextAbstractNumID());
        for (int i = 0; i < numFmts.length; ++i) {
            NumberingFormat numFmt = numFmts[i];
            CTLvl cTLvl = cTAbstractNum.addNewLvl();
            CTPPrGeneral ppr = cTLvl.isSetPPr() ? cTLvl.getPPr() : cTLvl.addNewPPr();
            CTInd ind = ppr.isSetInd() ? ppr.getInd() : ppr.addNewInd();
            ind.setLeft((Object)BigInteger.valueOf(UnitUtils.cm2Twips(0.74f) * i));
            STNumberFormat.Enum fmt = STNumberFormat.Enum.forInt((int)numFmt.getNumFmt());
            String val = numFmt.getLvlText();
            cTLvl.addNewNumFmt().setVal(fmt);
            cTLvl.addNewLvlText().setVal(val);
            cTLvl.addNewStart().setVal(BigInteger.valueOf(1L));
            cTLvl.setIlvl(BigInteger.valueOf(i));
            if (fmt != STNumberFormat.BULLET) continue;
            cTLvl.addNewLvlJc().setVal(STJc.LEFT);
            CTRPr addNewRPr = cTLvl.addNewRPr();
            CTFonts ctFonts = addNewRPr.addNewRFonts();
            ctFonts.setAscii("Wingdings");
            ctFonts.setHAnsi("Wingdings");
            ctFonts.setHint(STHint.DEFAULT);
        }
        XWPFAbstractNum abstractNum = new XWPFAbstractNum(cTAbstractNum);
        BigInteger abstractNumID = numbering.addAbstractNum(abstractNum);
        return numbering.addNum(abstractNumID);
    }

    public POIXMLDocumentPart.RelationPart addChartData(XWPFChart chart) throws InvalidFormatException, IOException {
        int chartNumber = this.getNextPartNumber((POIXMLRelation)XWPFRelation.CHART, this.charts.size() + 1);
        PackagePart packagePart = this.chartMappingPart.getOrDefault(chart, chart.getPackagePart());
        POIXMLDocumentPart.RelationPart rp = this.createRelationship((POIXMLRelation)XWPFRelation.CHART, new XWPFChartFactory(packagePart), chartNumber, false);
        XWPFChart xwpfChart = (XWPFChart)rp.getDocumentPart();
        xwpfChart.setChartIndex(chartNumber);
        xwpfChart.setWorkbook(PoitlIOUtils.cloneWorkbook(chart.getWorkbook(), false));
        this.charts.add(xwpfChart);
        this.chartMappingPart.put(xwpfChart, packagePart);
        return rp;
    }

    public String addEmbeddData(byte[] embeddData, int format) throws InvalidFormatException {
        XWPFRelation relation = 0 == format ? DOCUMENT : XWPFRelation.WORKBOOK;
        int idx = 256 + this.getRelationIndex(relation);
        POIXMLDocumentPart embeddPart = this.createRelationship((POIXMLRelation)relation, (POIXMLFactory)XWPFFactory.getInstance(), idx);
        this.embedds.add(embeddPart);
        PackagePart picDataPart = embeddPart.getPackagePart();
        try (OutputStream out = picDataPart.getOutputStream();){
            out.write(embeddData);
        }
        catch (IOException e) {
            throw new POIXMLException((Throwable)e);
        }
        return this.getRelationId(embeddPart);
    }

    public String addEmbeddData(byte[] embeddData, String contentType, String part) throws InvalidFormatException, IOException {
        PackagePartName partName = PackagingURIHelper.createPartName((String)part);
        PackagePart packagePart = this.getPackage().createPart(partName, contentType);
        try (OutputStream out = packagePart.getOutputStream();){
            out.write(embeddData);
        }
        catch (IOException e) {
            throw new POIXMLException((Throwable)e);
        }
        PackageRelationship ole = this.getPackagePart().addRelationship(partName, TargetMode.INTERNAL, "http://schemas.openxmlformats.org/officeDocument/2006/relationships/package");
        return ole.getId();
    }

    private int getRelationIndex(XWPFRelation relation) {
        int i = 1;
        for (POIXMLDocumentPart.RelationPart rp : this.getRelationParts()) {
            if (!rp.getRelationship().getRelationshipType().equals(relation.getRelation())) continue;
            ++i;
        }
        return i;
    }

    protected void commit() throws IOException {
        this.saveEmbedds();
        super.commit();
    }

    private void saveEmbedds() {
        this.embedds.forEach(part -> part.setCommitted(true));
    }

    public NiceXWPFDocument generate() throws IOException {
        return this.generate(false);
    }

    public NiceXWPFDocument generate(boolean adjust) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.write(byteArrayOutputStream);
        this.close();
        return new NiceXWPFDocument(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), adjust);
    }

    public NiceXWPFDocument merge(NiceXWPFDocument docMerge) throws Exception {
        return this.merge(Arrays.asList(docMerge), this.createParagraph().createRun());
    }

    public NiceXWPFDocument merge(List<NiceXWPFDocument> docMerges, XWPFRun run) throws Exception {
        if (null == docMerges || docMerges.isEmpty() || null == run) {
            return this;
        }
        return this.merge(docMerges.iterator(), run);
    }

    public NiceXWPFDocument merge(Iterator<NiceXWPFDocument> iterator, XWPFRun run) throws Exception {
        XWPFRun newRun = run;
        String paragraphText = ParagraphUtils.trimLine((XWPFParagraph)run.getParent());
        boolean havePictures = ParagraphUtils.havePictures((XWPFParagraph)run.getParent());
        if (!ParagraphUtils.trimLine(run.text()).equals(paragraphText) || havePictures) {
            BodyContainer container = BodyContainerFactory.getBodyContainer(run);
            XWPFParagraph paragraph = container.insertNewParagraph(run);
            newRun = paragraph.createRun();
        }
        return new XmlXWPFDocumentMerge().merge(this, iterator, newRun);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XWPFParagraph insertNewParagraph(XmlCursor cursor) {
        if (this.isCursorInBody(cursor)) {
            String uri = CTP.type.getName().getNamespaceURI();
            String localPart = "p";
            cursor.beginElement(localPart, uri);
            cursor.toParent();
            CTP p = (CTP)cursor.getObject();
            XWPFParagraph newP = new XWPFParagraph(p, (IBody)this);
            XmlObject o = null;
            while (!(o instanceof CTP) && cursor.toPrevSibling()) {
                o = cursor.getObject();
            }
            if (!(o instanceof CTP) || o == p) {
                this.paragraphs.add(0, newP);
            } else {
                int pos = this.paragraphs.indexOf(this.getParagraph((CTP)o)) + 1;
                this.paragraphs.add(pos, newP);
            }
            XmlCursor newParaPos = p.newCursor();
            try {
                int i = 0;
                cursor.toCursor(newParaPos);
                while (cursor.toPrevSibling()) {
                    o = cursor.getObject();
                    if (!(o instanceof CTP) && !(o instanceof CTTbl) && !(o instanceof CTSdtBlock)) continue;
                    ++i;
                }
                this.bodyElements.add(i, newP);
                cursor.toCursor(newParaPos);
                cursor.toEndToken();
                XWPFParagraph xWPFParagraph = newP;
                return xWPFParagraph;
            }
            finally {
                newParaPos.dispose();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XWPFTable insertNewTbl(XmlCursor cursor) {
        if (this.isCursorInBody(cursor)) {
            String uri = CTTbl.type.getName().getNamespaceURI();
            String localPart = "tbl";
            cursor.beginElement(localPart, uri);
            cursor.toParent();
            CTTbl t = (CTTbl)cursor.getObject();
            XWPFTable newT = new XWPFTable(t, (IBody)this);
            XmlObject o = null;
            while (!(o instanceof CTTbl) && cursor.toPrevSibling()) {
                o = cursor.getObject();
            }
            if (!(o instanceof CTTbl)) {
                this.tables.add(0, newT);
            } else {
                int pos = this.tables.indexOf(this.getTable((CTTbl)o)) + 1;
                this.tables.add(pos, newT);
            }
            int i = 0;
            XmlCursor tableCursor = t.newCursor();
            try {
                cursor.toCursor(tableCursor);
                while (cursor.toPrevSibling()) {
                    o = cursor.getObject();
                    if (!(o instanceof CTP) && !(o instanceof CTTbl) && !(o instanceof CTSdtBlock)) continue;
                    ++i;
                }
                this.bodyElements.add(i, newT);
                cursor.toCursor(tableCursor);
                cursor.toEndToken();
                XWPFTable xWPFTable = newT;
                return xWPFTable;
            }
            finally {
                tableCursor.dispose();
            }
        }
        return null;
    }

    private boolean isCursorInBody(XmlCursor cursor) {
        XmlCursor verify = cursor.newCursor();
        verify.toParent();
        boolean result = verify.getObject() == this.getDocument().getBody();
        verify.dispose();
        return result;
    }

    private void read(IBody body) {
        this.readParagraphs(body.getParagraphs());
        this.readTables(body.getTables());
    }

    private void readParagraphs(List<XWPFParagraph> paragraphs) {
        paragraphs.forEach(paragraph -> paragraph.getRuns().forEach(run -> this.readRun((XWPFRun)run)));
    }

    private void readRun(XWPFRun run) {
        this.allPictures.addAll(run.getEmbeddedPictures());
        if (!this.idenifierManagerWrapper.isValid()) {
            return;
        }
        CTR r = run.getCTR();
        XmlObject[] xmlObjects = r.selectPath("declare namespace w='http://schemas.openxmlformats.org/wordprocessingml/2006/main' \n        declare namespace mc='http://schemas.openxmlformats.org/markup-compatibility/2006' .//mc:AlternateContent/mc:Choice/w:drawing");
        if (null == xmlObjects || xmlObjects.length <= 0) {
            return;
        }
        for (XmlObject xmlObject : xmlObjects) {
            try {
                long reserve;
                long id;
                CTDrawing ctDrawing = (CTDrawing)CTDrawing.Factory.parse(xmlObject.xmlText());
                for (CTAnchor anchor : ctDrawing.getAnchorList()) {
                    if (anchor.getDocPr() == null) continue;
                    id = anchor.getDocPr().getId();
                    reserve = this.idenifierManagerWrapper.reserve(id);
                    if (!this.adjustDoc || id == reserve) continue;
                    anchor.getDocPr().setId(reserve);
                    xmlObject.set((XmlObject)ctDrawing);
                }
                for (CTInline inline : ctDrawing.getInlineList()) {
                    if (inline.getDocPr() == null) continue;
                    id = inline.getDocPr().getId();
                    reserve = this.idenifierManagerWrapper.reserve(id);
                    if (!this.adjustDoc || id == reserve) continue;
                    inline.getDocPr().setId(reserve);
                    xmlObject.set((XmlObject)ctDrawing);
                }
            }
            catch (XmlException xmlException) {
                // empty catch block
            }
        }
    }

    private void readTables(List<XWPFTable> tables) {
        this.allTables.addAll(tables);
        for (XWPFTable table : tables) {
            List rows = table.getRows();
            if (null == rows) continue;
            for (XWPFTableRow row : rows) {
                List cells = row.getTableCells();
                if (null == cells) continue;
                for (XWPFTableCell cell : cells) {
                    this.read((IBody)cell);
                }
            }
        }
    }

    public boolean removeBodyElement(int pos) {
        if (pos >= 0 && pos < this.bodyElements.size()) {
            int paraPos;
            BodyElementType type = ((IBodyElement)this.bodyElements.get(pos)).getElementType();
            if (type == BodyElementType.TABLE) {
                paraPos = this.getTablePos(pos);
                this.tables.remove(paraPos);
                this.getDocument().getBody().removeTbl(paraPos);
            }
            if (type == BodyElementType.PARAGRAPH) {
                paraPos = this.getParagraphPos(pos);
                this.paragraphs.remove(paraPos);
                this.getDocument().getBody().removeP(paraPos);
            }
            if (type == BodyElementType.CONTENTCONTROL) {
                paraPos = this.getBodyElementSpecificPos(pos, this.contentControls);
                this.contentControls.remove(paraPos);
                this.getDocument().getBody().removeSdt(paraPos);
            }
            this.bodyElements.remove(pos);
            return true;
        }
        return false;
    }

    private int getBodyElementSpecificPos(int pos, List<? extends IBodyElement> list) {
        if (list.isEmpty()) {
            return -1;
        }
        if (pos >= 0 && pos < this.bodyElements.size()) {
            int startPos;
            IBodyElement needle = (IBodyElement)this.bodyElements.get(pos);
            if (needle.getElementType() != list.get(0).getElementType()) {
                return -1;
            }
            for (int i = startPos = Math.min(pos, list.size() - 1); i >= 0; --i) {
                if (list.get(i) != needle) continue;
                return i;
            }
        }
        return -1;
    }

    static {
        try {
            Constructor<XWPFRelation> constructor = ReflectionUtils.findConstructor(XWPFRelation.class, String.class, String.class, String.class, POIXMLRelation.NoArgConstructor.class, POIXMLRelation.PackagePartConstructor.class);
            DOCUMENT = constructor.newInstance("application/vnd.openxmlformats-officedocument.wordprocessingml.document", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/package", "/word/embeddings/Microsoft_Word_#.docx", new POIXMLRelation.NoArgConstructor(){

                public POIXMLDocumentPart init() {
                    return new XWPFDocument();
                }
            }, new POIXMLRelation.PackagePartConstructor(){

                public POIXMLDocumentPart init(PackagePart part) throws IOException, XmlException {
                    return new XWPFDocument(part.getInputStream());
                }
            });
        }
        catch (Exception e) {
            logger.warn("init releation error: {}", (Object)e.getMessage());
        }
    }
}

