/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.xwpf;

import com.deepoove.poi.xwpf.Page;
import com.deepoove.poi.xwpf.XWPFPageMargin;
import com.deepoove.poi.xwpf.XWPFPageSize;
import java.math.BigInteger;
import java.util.List;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHdrFtrRef;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSectPr;

public class XWPFSection {
    protected CTSectPr sectPr;
    protected XWPFPageMargin pageMargin;
    protected XWPFPageSize pageSize;

    public XWPFSection(CTSectPr sectPr) {
        this.sectPr = sectPr;
        if (sectPr.isSetPgMar()) {
            this.pageMargin = new XWPFPageMargin(sectPr.getPgMar());
        }
        if (sectPr.isSetPgSz()) {
            this.pageSize = new XWPFPageSize(sectPr.getPgSz());
        }
    }

    public boolean haveHeader(String headerRelationId) {
        if (null == headerRelationId) {
            return false;
        }
        List referenceList = this.sectPr.getHeaderReferenceList();
        for (CTHdrFtrRef ref : referenceList) {
            String id = ref.getId();
            if (!id.equals(headerRelationId)) continue;
            return true;
        }
        return false;
    }

    public boolean haveFooter(String footerRelationId) {
        if (null == footerRelationId) {
            return false;
        }
        List referenceList = this.sectPr.getFooterReferenceList();
        for (CTHdrFtrRef ref : referenceList) {
            String id = ref.getId();
            if (!id.equals(footerRelationId)) continue;
            return true;
        }
        return false;
    }

    public CTSectPr getSectPr() {
        return this.sectPr;
    }

    public XWPFPageMargin getPageMargin() {
        return this.pageMargin;
    }

    public XWPFPageSize getPageSize() {
        return this.pageSize;
    }

    public int getPageWidth() {
        return null == this.pageSize ? -1 : this.pageSize.getWidth();
    }

    public int getPageHeight() {
        return null == this.pageSize ? -1 : this.pageSize.getHeight();
    }

    public BigInteger getPageContentWidth() {
        long margin = 0L;
        if (null != this.pageMargin) {
            margin = this.pageMargin.getLeft().longValue() + this.pageMargin.getRight().longValue();
        }
        return BigInteger.valueOf((null == this.pageSize ? Page.A4_NORMAL.contentWidth().longValue() : (long)this.getPageWidth()) - margin);
    }
}

