/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.config;

import com.deepoove.poi.config.GramerSymbol;
import com.deepoove.poi.policy.DocxRenderPolicy;
import com.deepoove.poi.policy.NumbericRenderPolicy;
import com.deepoove.poi.policy.PictureRenderPolicy;
import com.deepoove.poi.policy.RenderPolicy;
import com.deepoove.poi.policy.SimpleTableRenderPolicy;
import com.deepoove.poi.policy.TextRenderPolicy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Configure {
    private Map<String, RenderPolicy> customPolicys = new HashMap<String, RenderPolicy>(6);
    private Map<Character, RenderPolicy> defaultPolicys = new HashMap<Character, RenderPolicy>(12);
    private Set<Character> gramerChars = new HashSet<Character>();
    private String gramerPrefix = "{{";
    private String gramerSuffix = "}}";

    private Configure() {
        this.plugin(GramerSymbol.TEXT.getSymbol(), new TextRenderPolicy());
        this.plugin(GramerSymbol.IMAGE.getSymbol(), new PictureRenderPolicy());
        this.plugin(GramerSymbol.TABLE.getSymbol(), new SimpleTableRenderPolicy());
        this.plugin(GramerSymbol.NUMBERIC.getSymbol(), new NumbericRenderPolicy());
        this.plugin(GramerSymbol.DOCX_TEMPLATE.getSymbol(), new DocxRenderPolicy());
    }

    public static Configure createDefault() {
        return Configure.newBuilder().build();
    }

    public static ConfigureBuilder newBuilder() {
        return new ConfigureBuilder();
    }

    public Configure plugin(char c, RenderPolicy policy) {
        this.gramerChars.add(Character.valueOf(c));
        this.defaultPolicys.put(Character.valueOf(c), policy);
        return this;
    }

    public void customPolicy(String tagName, RenderPolicy policy) {
        this.customPolicys.put(tagName, policy);
    }

    public RenderPolicy getPolicy(String tagName, Character sign) {
        RenderPolicy policy = this.getCustomPolicy(tagName);
        return null == policy ? this.getDefaultPolicy(sign) : policy;
    }

    public Map<Character, RenderPolicy> getDefaultPolicys() {
        return this.defaultPolicys;
    }

    public Map<String, RenderPolicy> getCustomPolicys() {
        return this.customPolicys;
    }

    public Set<Character> getGramerChars() {
        return this.gramerChars;
    }

    public String getGramerPrefix() {
        return this.gramerPrefix;
    }

    public String getGramerSuffix() {
        return this.gramerSuffix;
    }

    private RenderPolicy getCustomPolicy(String tagName) {
        return this.customPolicys.get(tagName);
    }

    private RenderPolicy getDefaultPolicy(Character sign) {
        return this.defaultPolicys.get(sign);
    }

    public static class ConfigureBuilder {
        private Configure config = new Configure();

        public ConfigureBuilder buildGramer(String prefix, String suffix) {
            this.config.gramerPrefix = prefix;
            this.config.gramerSuffix = suffix;
            return this;
        }

        public ConfigureBuilder addPlugin(char c, RenderPolicy policy) {
            this.config.plugin(c, policy);
            return this;
        }

        public ConfigureBuilder customPolicy(String tagName, RenderPolicy policy) {
            this.config.customPolicy(tagName, policy);
            return this;
        }

        public Configure build() {
            return this.config;
        }
    }
}

