/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.policy;

import com.deepoove.poi.NiceXWPFDocument;
import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.data.MiniTableRenderData;
import com.deepoove.poi.data.RenderData;
import com.deepoove.poi.data.TableRenderData;
import com.deepoove.poi.data.TextRenderData;
import com.deepoove.poi.data.style.Style;
import com.deepoove.poi.policy.MiniTableRenderPolicy;
import com.deepoove.poi.policy.RenderPolicy;
import com.deepoove.poi.template.ElementTemplate;
import com.deepoove.poi.template.run.RunTemplate;
import java.math.BigInteger;
import java.util.List;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblBorders;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblGrid;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblGridCol;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblWidth;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STTblWidth;

public class SimpleTableRenderPolicy
implements RenderPolicy {
    private MiniTableRenderPolicy miniTableRenderPolicy = new MiniTableRenderPolicy();

    @Override
    public void render(ElementTemplate eleTemplate, Object data, XWPFTemplate template) {
        NiceXWPFDocument doc = template.getXWPFDocument();
        RunTemplate runTemplate = (RunTemplate)eleTemplate;
        XWPFRun run = runTemplate.getRun();
        if (null == data) {
            return;
        }
        if (data instanceof MiniTableRenderData) {
            this.miniTableRenderPolicy.render(eleTemplate, data, template);
            return;
        }
        TableRenderData tableData = (TableRenderData)data;
        List<RenderData> headers = tableData.getHeaders();
        List<Object> datas = tableData.getDatas();
        if (datas == null || datas.isEmpty()) {
            if (headers == null || headers.isEmpty()) {
                runTemplate.getRun().setText("", 0);
                return;
            }
            XWPFTable table = doc.insertNewTable(run, 2, headers.size());
            if (null == table) {
                logger.warn("cannot insert table.");
                return;
            }
            this.widthTable(table, tableData.getWidth(), 2, headers.size());
            this.createHeader(table, headers);
            NiceXWPFDocument.mergeCellsHorizonal(table, 1, 0, headers.size() - 1);
            XWPFTableCell cell = table.getRow(1).getCell(0);
            cell.setText(tableData.getNoDatadesc());
        } else {
            int maxColom = 0;
            int row = datas.size();
            int startRow = 1;
            if (headers == null || headers.isEmpty()) {
                startRow = 0;
                maxColom = this.getMaxColumFromData(datas);
            } else {
                ++row;
                maxColom = headers.size();
            }
            XWPFTable table = doc.insertNewTable(run, row, maxColom);
            this.widthTable(table, tableData.getWidth(), row, maxColom);
            this.createHeader(table, headers);
            for (Object obj : datas) {
                if (null == obj) continue;
                String str = obj.toString();
                String[] split = str.split(";");
                int length = split.length;
                for (int m = 0; m < length; ++m) {
                    XWPFTableCell cell = table.getRow(startRow).getCell(m);
                    String[] fragment = split[m].split("\\n");
                    if (null == fragment) continue;
                    cell.setText(fragment[0]);
                    for (int i = 1; i < fragment.length; ++i) {
                        XWPFParagraph addParagraph = cell.addParagraph();
                        addParagraph.createRun().setText(fragment[i]);
                    }
                }
                ++startRow;
            }
        }
        runTemplate.getRun().setText("", 0);
    }

    private void widthTable(XWPFTable table, int width, int rows, int cols) {
        CTTblWidth tblW;
        CTTblPr tblPr = table.getCTTbl().getTblPr();
        if (null == tblPr) {
            tblPr = table.getCTTbl().addNewTblPr();
        }
        if ((tblW = tblPr.getTblW()) == null) {
            tblW = tblPr.addNewTblW();
        }
        tblW.setType(0 == width ? STTblWidth.AUTO : STTblWidth.DXA);
        tblW.setW(BigInteger.valueOf(width));
        if (0 != width) {
            CTTblGrid tblGrid = table.getCTTbl().getTblGrid();
            if (null == tblGrid) {
                tblGrid = table.getCTTbl().addNewTblGrid();
            }
            for (int j = 0; j < cols; ++j) {
                CTTblGridCol addNewGridCol = tblGrid.addNewGridCol();
                addNewGridCol.setW(BigInteger.valueOf(width / cols));
            }
        }
        CTTblBorders tblBorders = tblPr.getTblBorders();
        tblBorders.getBottom().setSz(BigInteger.valueOf(4L));
        tblBorders.getLeft().setSz(BigInteger.valueOf(4L));
        tblBorders.getTop().setSz(BigInteger.valueOf(4L));
        tblBorders.getRight().setSz(BigInteger.valueOf(4L));
        tblBorders.getInsideH().setSz(BigInteger.valueOf(4L));
        tblBorders.getInsideV().setSz(BigInteger.valueOf(4L));
    }

    private int getMaxColumFromData(List<Object> datas) {
        int maxColom = 0;
        for (Object obj : datas) {
            String str;
            String[] split;
            if (null == obj || (split = (str = obj.toString()).split(";")).length <= maxColom) continue;
            maxColom = split.length;
        }
        return maxColom;
    }

    private void createHeader(XWPFTable table, List<RenderData> headers) {
        if (null == headers || headers.isEmpty()) {
            return;
        }
        int i = 0;
        for (RenderData head : headers) {
            TextRenderData textHead = (TextRenderData)head;
            Style style = textHead.getStyle();
            String color = null == style ? null : style.getColor();
            XWPFTableCell cell = table.getRow(0).getCell(i);
            String[] fragment = textHead.getText().split("\\n");
            if (null != fragment) {
                cell.setText(fragment[0]);
                for (int j = 1; j < fragment.length; ++j) {
                    XWPFParagraph addParagraph = cell.addParagraph();
                    addParagraph.createRun().setText(fragment[j]);
                }
            }
            if (null != color) {
                table.getRow(0).getCell(i).setColor(color);
            }
            ++i;
        }
    }
}

