/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.policy.ref;

import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.exception.RenderException;
import org.apache.commons.lang3.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReferenceRenderPolicy<T> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    protected abstract T locate(XWPFTemplate var1);

    public abstract void doRender(T var1, XWPFTemplate var2) throws Exception;

    public void render(XWPFTemplate template) {
        try {
            T locate = this.locate(template);
            this.logger.info("Located the {} object: {}", (Object)ClassUtils.getSimpleName(locate.getClass()), locate);
            this.doRender(locate, template);
        }
        catch (Exception e) {
            throw new RenderException("ReferenceRenderPolicy render error", e);
        }
    }
}

