/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.render;

import com.deepoove.poi.NiceXWPFDocument;
import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.config.Configure;
import com.deepoove.poi.exception.RenderException;
import com.deepoove.poi.policy.DocxRenderPolicy;
import com.deepoove.poi.policy.RenderPolicy;
import com.deepoove.poi.policy.ref.ReferenceRenderPolicy;
import com.deepoove.poi.render.ELObjectRenderDataCompute;
import com.deepoove.poi.render.RenderDataCompute;
import com.deepoove.poi.template.ElementTemplate;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Render {
    private static final Logger LOGGER = LoggerFactory.getLogger(Render.class);
    private RenderDataCompute renderDataCompute;

    public Render(Object root) {
        Objects.requireNonNull(root, "Data root must not be null");
        this.renderDataCompute = new ELObjectRenderDataCompute(root, false);
    }

    public Render(RenderDataCompute dataCompute) {
        this.renderDataCompute = dataCompute;
    }

    public void render(XWPFTemplate template) {
        Objects.requireNonNull(template, "Template must not be null.");
        LOGGER.info("Render the template file start...");
        StopWatch watch = new StopWatch();
        try {
            watch.start();
            this.applyReferencePolicy(template);
            int docxCount = this.applyNormalPolicy(template);
            if (docxCount >= 1) {
                template.reload(template.getXWPFDocument().generate());
                this.applyDocxPolicy(template, docxCount);
            }
        }
        catch (Exception e) {
            throw new RenderException("Cannot render docx template, please check the Exception", e);
        }
        finally {
            watch.stop();
        }
        LOGGER.info("Successfully Render the template file in {} millis", (Object)TimeUnit.NANOSECONDS.toMillis(watch.getNanoTime()));
    }

    public void applyReferencePolicy(XWPFTemplate template) {
        Configure config = template.getConfig();
        List<ReferenceRenderPolicy<?>> referencePolicies = config.getReferencePolicies();
        for (ReferenceRenderPolicy<?> policy : referencePolicies) {
            this.doRender(policy, template);
        }
    }

    private int applyNormalPolicy(XWPFTemplate template) {
        RenderPolicy policy = null;
        int docxItems = 0;
        List<ElementTemplate> elementTemplates = template.getElementTemplates();
        for (ElementTemplate runTemplate : elementTemplates) {
            policy = this.findPolicy(template.getConfig(), runTemplate);
            if (policy instanceof DocxRenderPolicy) {
                ++docxItems;
                continue;
            }
            this.doRender(runTemplate, policy, template);
        }
        return docxItems;
    }

    private void applyDocxPolicy(XWPFTemplate template, int docxItems) {
        List<ElementTemplate> elementTemplates = null;
        RenderPolicy policy = null;
        NiceXWPFDocument current = template.getXWPFDocument();
        block0: for (int i = 0; i < docxItems && !(elementTemplates = template.getElementTemplates()).isEmpty(); ++i) {
            for (ElementTemplate runTemplate : elementTemplates) {
                policy = this.findPolicy(template.getConfig(), runTemplate);
                if (!(policy instanceof DocxRenderPolicy)) continue;
                this.doRender(runTemplate, policy, template);
                if (current == template.getXWPFDocument()) {
                    ++i;
                    continue;
                }
                current = template.getXWPFDocument();
                continue block0;
            }
        }
    }

    private RenderPolicy findPolicy(Configure config, ElementTemplate runTemplate) {
        RenderPolicy policy = config.getPolicy(runTemplate.getTagName(), runTemplate.getSign());
        if (null == policy) {
            throw new RenderException("Cannot find render policy: [" + runTemplate.getTagName() + "]");
        }
        return policy;
    }

    private void doRender(ElementTemplate ele, RenderPolicy policy, XWPFTemplate template) {
        LOGGER.info("Start render TemplateName:{}, Sign:{}, policy:{}", new Object[]{ele.getTagName(), ele.getSign(), ClassUtils.getShortClassName(policy.getClass())});
        policy.render(ele, this.renderDataCompute.compute(ele.getTagName()), template);
    }

    private void doRender(ReferenceRenderPolicy<?> policy, XWPFTemplate template) {
        LOGGER.info("Start apply Reference Render Policy:{}", (Object)ClassUtils.getShortClassName(policy.getClass()));
        policy.render(template);
    }
}

