/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.config;

import com.deepoove.poi.config.ConfigureBuilder;
import com.deepoove.poi.config.GramerSymbol;
import com.deepoove.poi.exception.RenderException;
import com.deepoove.poi.policy.DocxRenderPolicy;
import com.deepoove.poi.policy.MiniTableRenderPolicy;
import com.deepoove.poi.policy.NumbericRenderPolicy;
import com.deepoove.poi.policy.PictureRenderPolicy;
import com.deepoove.poi.policy.RenderPolicy;
import com.deepoove.poi.policy.TextRenderPolicy;
import com.deepoove.poi.policy.ref.ReferenceRenderPolicy;
import com.deepoove.poi.render.RenderContext;
import com.deepoove.poi.render.compute.DefaultRenderDataComputeFactory;
import com.deepoove.poi.render.compute.RenderDataComputeFactory;
import com.deepoove.poi.resolver.DefaultRunTemplateFactory;
import com.deepoove.poi.resolver.RunTemplateFactory;
import com.deepoove.poi.util.RegexUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;

public class Configure
implements Cloneable {
    public static final String DEFAULT_GRAMER_REGEX = "((#)?[\\w\\u4e00-\\u9fa5]+(\\.[\\w\\u4e00-\\u9fa5]+)*)?";
    private final Map<String, RenderPolicy> CUSTOM_POLICYS = new HashMap<String, RenderPolicy>();
    private final Map<Character, RenderPolicy> DEFAULT_POLICYS = new HashMap<Character, RenderPolicy>();
    private final List<ReferenceRenderPolicy<?>> REFERENCE_POLICIES = new ArrayList();
    Pair<Character, Character> iterable = Pair.of((Object)Character.valueOf(GramerSymbol.ITERABLE_START.getSymbol()), (Object)Character.valueOf(GramerSymbol.BLOCK_END.getSymbol()));
    String gramerPrefix = "{{";
    String gramerSuffix = "}}";
    String grammerRegex = "((#)?[\\w\\u4e00-\\u9fa5]+(\\.[\\w\\u4e00-\\u9fa5]+)*)?";
    ELMode elMode = ELMode.POI_TL_STANDARD_MODE;
    RenderDataComputeFactory renderDataComputeFactory = new DefaultRenderDataComputeFactory(this);
    RunTemplateFactory<?> runTemplateFactory = new DefaultRunTemplateFactory(this);
    ValidErrorHandler handler = new ClearHandler();

    Configure() {
        this.plugin(GramerSymbol.TEXT, (RenderPolicy)new TextRenderPolicy());
        this.plugin(GramerSymbol.TEXT_ALIAS, (RenderPolicy)new TextRenderPolicy());
        this.plugin(GramerSymbol.IMAGE, (RenderPolicy)new PictureRenderPolicy());
        this.plugin(GramerSymbol.TABLE, (RenderPolicy)new MiniTableRenderPolicy());
        this.plugin(GramerSymbol.NUMBERIC, (RenderPolicy)new NumbericRenderPolicy());
        this.plugin(GramerSymbol.DOCX_TEMPLATE, (RenderPolicy)new DocxRenderPolicy());
    }

    public static Configure createDefault() {
        return Configure.newBuilder().build();
    }

    public static ConfigureBuilder newBuilder() {
        return new ConfigureBuilder();
    }

    public Configure plugin(char c, RenderPolicy policy) {
        this.DEFAULT_POLICYS.put(Character.valueOf(c), policy);
        return this;
    }

    Configure plugin(GramerSymbol symbol, RenderPolicy policy) {
        this.DEFAULT_POLICYS.put(Character.valueOf(symbol.getSymbol()), policy);
        return this;
    }

    public void customPolicy(String tagName, RenderPolicy policy) {
        this.CUSTOM_POLICYS.put(tagName, policy);
    }

    public void referencePolicy(ReferenceRenderPolicy<?> policy) {
        this.REFERENCE_POLICIES.add(policy);
    }

    public RenderPolicy getPolicy(String tagName, Character sign) {
        RenderPolicy policy = this.getCustomPolicy(tagName);
        return null == policy ? this.getDefaultPolicy(sign) : policy;
    }

    public List<ReferenceRenderPolicy<?>> getReferencePolicies() {
        return this.REFERENCE_POLICIES;
    }

    private RenderPolicy getCustomPolicy(String tagName) {
        return this.CUSTOM_POLICYS.get(tagName);
    }

    private RenderPolicy getDefaultPolicy(Character sign) {
        return this.DEFAULT_POLICYS.get(sign);
    }

    public Map<Character, RenderPolicy> getDefaultPolicys() {
        return this.DEFAULT_POLICYS;
    }

    public Map<String, RenderPolicy> getCustomPolicys() {
        return this.CUSTOM_POLICYS;
    }

    public Set<Character> getGramerChars() {
        HashSet<Character> ret = new HashSet<Character>(this.DEFAULT_POLICYS.keySet());
        ret.add((Character)this.iterable.getKey());
        ret.add((Character)this.iterable.getValue());
        return ret;
    }

    public String getGramerPrefix() {
        return this.gramerPrefix;
    }

    public String getGramerSuffix() {
        return this.gramerSuffix;
    }

    public String getGrammerRegex() {
        return this.grammerRegex;
    }

    public ELMode getElMode() {
        return this.elMode;
    }

    public ValidErrorHandler getValidErrorHandler() {
        return this.handler;
    }

    public RenderDataComputeFactory getRenderDataComputeFactory() {
        return this.renderDataComputeFactory;
    }

    public RunTemplateFactory<?> getRunTemplateFactory() {
        return this.runTemplateFactory;
    }

    public Pair<Character, Character> getIterable() {
        return this.iterable;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Configure Info").append(":\n");
        sb.append("  Basic gramer: ").append(this.gramerPrefix).append(this.gramerSuffix).append("\n");
        sb.append("  If and foreach gramer: ").append(this.gramerPrefix).append(this.iterable.getLeft()).append(this.gramerSuffix);
        sb.append(this.gramerPrefix).append(this.iterable.getRight()).append(this.gramerSuffix).append("\n");
        sb.append("  EL Mode: ").append((Object)this.elMode).append("\n");
        sb.append("  Regex:").append(this.grammerRegex).append("\n");
        sb.append("  Valid Error Handler: ").append(this.handler.getClass().getSimpleName()).append("\n");
        sb.append("  Default Plugin: ").append("\n");
        this.DEFAULT_POLICYS.forEach((chara, policy) -> {
            sb.append("    ").append(this.gramerPrefix).append(chara.charValue()).append(this.gramerSuffix);
            sb.append("->").append(policy.getClass().getSimpleName()).append("\n");
        });
        sb.append("  Bind Plugin: ").append("\n");
        this.CUSTOM_POLICYS.forEach((str, policy) -> {
            sb.append("    ").append(this.gramerPrefix).append((String)str).append(this.gramerSuffix);
            sb.append("->").append(policy.getClass().getSimpleName()).append("\n");
        });
        sb.append("  Reference Plugin: ").append("\n");
        this.REFERENCE_POLICIES.forEach(policy -> sb.append("    ").append(policy.getClass().getSimpleName()).append("\n"));
        return sb.toString();
    }

    protected Configure clone() throws CloneNotSupportedException {
        return (Configure)super.clone();
    }

    public Configure clone(String prefix, String suffix) throws CloneNotSupportedException {
        Configure clone = this.clone();
        clone.gramerPrefix = prefix;
        clone.gramerSuffix = suffix;
        if (clone.elMode == ELMode.SPEL_MODE) {
            clone.grammerRegex = RegexUtils.createGeneral(clone.gramerPrefix, clone.gramerSuffix);
        }
        return clone;
    }

    public static class AbortHandler
    implements ValidErrorHandler {
        @Override
        public void handler(RenderContext<?> context) {
            throw new RenderException("Non-existent variable and a variable with illegal value for " + context.getTagSource() + ", data: " + context.getData());
        }
    }

    public static class ClearHandler
    implements ValidErrorHandler {
        @Override
        public void handler(RenderContext<?> context) {
            context.getRun().setText("", 0);
        }
    }

    public static class DiscardHandler
    implements ValidErrorHandler {
        @Override
        public void handler(RenderContext<?> context) {
        }
    }

    public static interface ValidErrorHandler {
        public void handler(RenderContext<?> var1);
    }

    public static enum ELMode {
        POI_TL_STANDARD_MODE,
        POI_TL_STICT_MODE,
        SPEL_MODE;

    }
}

