/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.util;

import com.deepoove.poi.exception.ReflectionException;
import java.lang.reflect.Field;
import java.util.Objects;
import org.apache.commons.lang3.ClassUtils;

public class ReflectionUtils {
    public static Object getValue(String fieldName, Object obj) {
        Objects.requireNonNull(obj, "Class must not be null");
        Objects.requireNonNull(fieldName, "Name must not be null");
        Field field = ReflectionUtils.findField(obj.getClass(), fieldName);
        if (null == field) {
            throw new ReflectionException("No Such field " + fieldName + " from class" + ClassUtils.getShortClassName(obj.getClass()));
        }
        try {
            field.setAccessible(true);
            return field.get(obj);
        }
        catch (Exception e) {
            throw new ReflectionException(fieldName, obj.getClass(), e);
        }
    }

    public static Field findField(Class<?> clazz, String name) {
        Objects.requireNonNull(clazz, "Class must not be null");
        Objects.requireNonNull(name, "Name must not be null");
        for (Class<?> searchType = clazz; Object.class != searchType && searchType != null; searchType = searchType.getSuperclass()) {
            try {
                Field field = searchType.getDeclaredField(name);
                if (null == field) continue;
                return field;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        return null;
    }
}

